// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DesktopVirtualization.Models
{
    /// <summary> PersonalDesktopAssignment type for HostPool. </summary>
    public readonly partial struct PersonalDesktopAssignmentType : IEquatable<PersonalDesktopAssignmentType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PersonalDesktopAssignmentType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PersonalDesktopAssignmentType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AutomaticValue = "Automatic";
        private const string DirectValue = "Direct";

        /// <summary> Automatic. </summary>
        public static PersonalDesktopAssignmentType Automatic { get; } = new PersonalDesktopAssignmentType(AutomaticValue);
        /// <summary> Direct. </summary>
        public static PersonalDesktopAssignmentType Direct { get; } = new PersonalDesktopAssignmentType(DirectValue);
        /// <summary> Determines if two <see cref="PersonalDesktopAssignmentType"/> values are the same. </summary>
        public static bool operator ==(PersonalDesktopAssignmentType left, PersonalDesktopAssignmentType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PersonalDesktopAssignmentType"/> values are not the same. </summary>
        public static bool operator !=(PersonalDesktopAssignmentType left, PersonalDesktopAssignmentType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PersonalDesktopAssignmentType"/>. </summary>
        public static implicit operator PersonalDesktopAssignmentType(string value) => new PersonalDesktopAssignmentType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PersonalDesktopAssignmentType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PersonalDesktopAssignmentType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
