// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DesktopVirtualization.Models
{
    /// <summary> Is package timestamped so it can ignore the certificate expiry date. </summary>
    public readonly partial struct PackageTimestamped : IEquatable<PackageTimestamped>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PackageTimestamped"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PackageTimestamped(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TimestampedValue = "Timestamped";
        private const string NotTimestampedValue = "NotTimestamped";

        /// <summary> Timestamped. </summary>
        public static PackageTimestamped Timestamped { get; } = new PackageTimestamped(TimestampedValue);
        /// <summary> NotTimestamped. </summary>
        public static PackageTimestamped NotTimestamped { get; } = new PackageTimestamped(NotTimestampedValue);
        /// <summary> Determines if two <see cref="PackageTimestamped"/> values are the same. </summary>
        public static bool operator ==(PackageTimestamped left, PackageTimestamped right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PackageTimestamped"/> values are not the same. </summary>
        public static bool operator !=(PackageTimestamped left, PackageTimestamped right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PackageTimestamped"/>. </summary>
        public static implicit operator PackageTimestamped(string value) => new PackageTimestamped(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PackageTimestamped other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PackageTimestamped other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
