// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.DesktopVirtualization.Models
{
    public partial class ImportPackageInfoContent : IUtf8JsonSerializable, IJsonModel<ImportPackageInfoContent>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ImportPackageInfoContent>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ImportPackageInfoContent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ImportPackageInfoContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ImportPackageInfoContent)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Path))
            {
                writer.WritePropertyName("path"u8);
                writer.WriteStringValue(Path);
            }
            if (Optional.IsDefined(PackageArchitecture))
            {
                if (PackageArchitecture != null)
                {
                    writer.WritePropertyName("packageArchitecture"u8);
                    writer.WriteStringValue(PackageArchitecture.Value.ToString());
                }
                else
                {
                    writer.WriteNull("packageArchitecture");
                }
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ImportPackageInfoContent IJsonModel<ImportPackageInfoContent>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ImportPackageInfoContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ImportPackageInfoContent)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeImportPackageInfoContent(document.RootElement, options);
        }

        internal static ImportPackageInfoContent DeserializeImportPackageInfoContent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string path = default;
            AppAttachPackageArchitecture? packageArchitecture = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("path"u8))
                {
                    path = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("packageArchitecture"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        packageArchitecture = null;
                        continue;
                    }
                    packageArchitecture = new AppAttachPackageArchitecture(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ImportPackageInfoContent(path, packageArchitecture, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ImportPackageInfoContent>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ImportPackageInfoContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ImportPackageInfoContent)} does not support writing '{options.Format}' format.");
            }
        }

        ImportPackageInfoContent IPersistableModel<ImportPackageInfoContent>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ImportPackageInfoContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeImportPackageInfoContent(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ImportPackageInfoContent)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ImportPackageInfoContent>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
