// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DesktopVirtualization.Models
{
    /// <summary> The type of resetting the token. </summary>
    public readonly partial struct HostPoolRegistrationTokenOperation : IEquatable<HostPoolRegistrationTokenOperation>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HostPoolRegistrationTokenOperation"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HostPoolRegistrationTokenOperation(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DeleteValue = "Delete";
        private const string NoneValue = "None";
        private const string UpdateValue = "Update";

        /// <summary> Delete. </summary>
        public static HostPoolRegistrationTokenOperation Delete { get; } = new HostPoolRegistrationTokenOperation(DeleteValue);
        /// <summary> None. </summary>
        public static HostPoolRegistrationTokenOperation None { get; } = new HostPoolRegistrationTokenOperation(NoneValue);
        /// <summary> Update. </summary>
        public static HostPoolRegistrationTokenOperation Update { get; } = new HostPoolRegistrationTokenOperation(UpdateValue);
        /// <summary> Determines if two <see cref="HostPoolRegistrationTokenOperation"/> values are the same. </summary>
        public static bool operator ==(HostPoolRegistrationTokenOperation left, HostPoolRegistrationTokenOperation right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HostPoolRegistrationTokenOperation"/> values are not the same. </summary>
        public static bool operator !=(HostPoolRegistrationTokenOperation left, HostPoolRegistrationTokenOperation right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HostPoolRegistrationTokenOperation"/>. </summary>
        public static implicit operator HostPoolRegistrationTokenOperation(string value) => new HostPoolRegistrationTokenOperation(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HostPoolRegistrationTokenOperation other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HostPoolRegistrationTokenOperation other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
