// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DesktopVirtualization.Models
{
    /// <summary> Parameter indicating how the health check should behave if this package fails staging. </summary>
    public readonly partial struct FailHealthCheckOnStagingFailure : IEquatable<FailHealthCheckOnStagingFailure>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FailHealthCheckOnStagingFailure"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FailHealthCheckOnStagingFailure(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnhealthyValue = "Unhealthy";
        private const string NeedsAssistanceValue = "NeedsAssistance";
        private const string DoNotFailValue = "DoNotFail";

        /// <summary> Unhealthy. </summary>
        public static FailHealthCheckOnStagingFailure Unhealthy { get; } = new FailHealthCheckOnStagingFailure(UnhealthyValue);
        /// <summary> NeedsAssistance. </summary>
        public static FailHealthCheckOnStagingFailure NeedsAssistance { get; } = new FailHealthCheckOnStagingFailure(NeedsAssistanceValue);
        /// <summary> DoNotFail. </summary>
        public static FailHealthCheckOnStagingFailure DoNotFail { get; } = new FailHealthCheckOnStagingFailure(DoNotFailValue);
        /// <summary> Determines if two <see cref="FailHealthCheckOnStagingFailure"/> values are the same. </summary>
        public static bool operator ==(FailHealthCheckOnStagingFailure left, FailHealthCheckOnStagingFailure right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FailHealthCheckOnStagingFailure"/> values are not the same. </summary>
        public static bool operator !=(FailHealthCheckOnStagingFailure left, FailHealthCheckOnStagingFailure right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FailHealthCheckOnStagingFailure"/>. </summary>
        public static implicit operator FailHealthCheckOnStagingFailure(string value) => new FailHealthCheckOnStagingFailure(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FailHealthCheckOnStagingFailure other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FailHealthCheckOnStagingFailure other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
