// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.DesktopVirtualization.Models
{
    internal static partial class DesktopVirtualizationSkuTierExtensions
    {
        public static string ToSerialString(this DesktopVirtualizationSkuTier value) => value switch
        {
            DesktopVirtualizationSkuTier.Free => "Free",
            DesktopVirtualizationSkuTier.Basic => "Basic",
            DesktopVirtualizationSkuTier.Standard => "Standard",
            DesktopVirtualizationSkuTier.Premium => "Premium",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DesktopVirtualizationSkuTier value.")
        };

        public static DesktopVirtualizationSkuTier ToDesktopVirtualizationSkuTier(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Free")) return DesktopVirtualizationSkuTier.Free;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Basic")) return DesktopVirtualizationSkuTier.Basic;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Standard")) return DesktopVirtualizationSkuTier.Standard;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Premium")) return DesktopVirtualizationSkuTier.Premium;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DesktopVirtualizationSkuTier value.");
        }
    }
}
