// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DesktopVirtualization.Models
{
    /// <summary> Enabled allows this resource to be accessed from both public and private networks, Disabled allows this resource to only be accessed via private endpoints. </summary>
    public readonly partial struct DesktopVirtualizationPublicNetworkAccess : IEquatable<DesktopVirtualizationPublicNetworkAccess>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DesktopVirtualizationPublicNetworkAccess"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DesktopVirtualizationPublicNetworkAccess(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static DesktopVirtualizationPublicNetworkAccess Enabled { get; } = new DesktopVirtualizationPublicNetworkAccess(EnabledValue);
        /// <summary> Disabled. </summary>
        public static DesktopVirtualizationPublicNetworkAccess Disabled { get; } = new DesktopVirtualizationPublicNetworkAccess(DisabledValue);
        /// <summary> Determines if two <see cref="DesktopVirtualizationPublicNetworkAccess"/> values are the same. </summary>
        public static bool operator ==(DesktopVirtualizationPublicNetworkAccess left, DesktopVirtualizationPublicNetworkAccess right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DesktopVirtualizationPublicNetworkAccess"/> values are not the same. </summary>
        public static bool operator !=(DesktopVirtualizationPublicNetworkAccess left, DesktopVirtualizationPublicNetworkAccess right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DesktopVirtualizationPublicNetworkAccess"/>. </summary>
        public static implicit operator DesktopVirtualizationPublicNetworkAccess(string value) => new DesktopVirtualizationPublicNetworkAccess(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DesktopVirtualizationPublicNetworkAccess other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DesktopVirtualizationPublicNetworkAccess other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
