// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DesktopVirtualization.Models
{
    /// <summary> Schema for App Attach Package properties. </summary>
    public partial class AppAttachPackageProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AppAttachPackageProperties"/>. </summary>
        public AppAttachPackageProperties()
        {
            HostPoolReferences = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="AppAttachPackageProperties"/>. </summary>
        /// <param name="provisioningState"> The provisioning state of the App Attach Package. </param>
        /// <param name="image"> Detailed properties for App Attach Package. </param>
        /// <param name="hostPoolReferences"> List of Hostpool resource Ids. </param>
        /// <param name="keyVaultUri"> URL path to certificate name located in keyVault. </param>
        /// <param name="failHealthCheckOnStagingFailure"> Parameter indicating how the health check should behave if this package fails staging. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AppAttachPackageProperties(AppAttachPackageProvisioningState? provisioningState, AppAttachPackageInfoProperties image, IList<string> hostPoolReferences, Uri keyVaultUri, FailHealthCheckOnStagingFailure? failHealthCheckOnStagingFailure, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProvisioningState = provisioningState;
            Image = image;
            HostPoolReferences = hostPoolReferences;
            KeyVaultUri = keyVaultUri;
            FailHealthCheckOnStagingFailure = failHealthCheckOnStagingFailure;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The provisioning state of the App Attach Package. </summary>
        [WirePath("provisioningState")]
        public AppAttachPackageProvisioningState? ProvisioningState { get; }
        /// <summary> Detailed properties for App Attach Package. </summary>
        [WirePath("image")]
        public AppAttachPackageInfoProperties Image { get; set; }
        /// <summary> List of Hostpool resource Ids. </summary>
        [WirePath("hostPoolReferences")]
        public IList<string> HostPoolReferences { get; }
        /// <summary> URL path to certificate name located in keyVault. </summary>
        [WirePath("keyVaultURL")]
        public Uri KeyVaultUri { get; set; }
        /// <summary> Parameter indicating how the health check should behave if this package fails staging. </summary>
        [WirePath("failHealthCheckOnStagingFailure")]
        public FailHealthCheckOnStagingFailure? FailHealthCheckOnStagingFailure { get; set; }
    }
}
