// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.DesktopVirtualization.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableDesktopVirtualizationArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableDesktopVirtualizationArmClient"/> class for mocking. </summary>
        protected MockableDesktopVirtualizationArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableDesktopVirtualizationArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableDesktopVirtualizationArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableDesktopVirtualizationArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="VirtualWorkspaceResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="VirtualWorkspaceResource.CreateResourceIdentifier" /> to create a <see cref="VirtualWorkspaceResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="VirtualWorkspaceResource"/> object. </returns>
        public virtual VirtualWorkspaceResource GetVirtualWorkspaceResource(ResourceIdentifier id)
        {
            VirtualWorkspaceResource.ValidateResourceId(id);
            return new VirtualWorkspaceResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="WorkspacePrivateEndpointConnectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="WorkspacePrivateEndpointConnectionResource.CreateResourceIdentifier" /> to create a <see cref="WorkspacePrivateEndpointConnectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="WorkspacePrivateEndpointConnectionResource"/> object. </returns>
        public virtual WorkspacePrivateEndpointConnectionResource GetWorkspacePrivateEndpointConnectionResource(ResourceIdentifier id)
        {
            WorkspacePrivateEndpointConnectionResource.ValidateResourceId(id);
            return new WorkspacePrivateEndpointConnectionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="HostPoolPrivateEndpointConnectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="HostPoolPrivateEndpointConnectionResource.CreateResourceIdentifier" /> to create a <see cref="HostPoolPrivateEndpointConnectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="HostPoolPrivateEndpointConnectionResource"/> object. </returns>
        public virtual HostPoolPrivateEndpointConnectionResource GetHostPoolPrivateEndpointConnectionResource(ResourceIdentifier id)
        {
            HostPoolPrivateEndpointConnectionResource.ValidateResourceId(id);
            return new HostPoolPrivateEndpointConnectionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ScalingPlanResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ScalingPlanResource.CreateResourceIdentifier" /> to create a <see cref="ScalingPlanResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ScalingPlanResource"/> object. </returns>
        public virtual ScalingPlanResource GetScalingPlanResource(ResourceIdentifier id)
        {
            ScalingPlanResource.ValidateResourceId(id);
            return new ScalingPlanResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ScalingPlanPooledScheduleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ScalingPlanPooledScheduleResource.CreateResourceIdentifier" /> to create a <see cref="ScalingPlanPooledScheduleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ScalingPlanPooledScheduleResource"/> object. </returns>
        public virtual ScalingPlanPooledScheduleResource GetScalingPlanPooledScheduleResource(ResourceIdentifier id)
        {
            ScalingPlanPooledScheduleResource.ValidateResourceId(id);
            return new ScalingPlanPooledScheduleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ScalingPlanPersonalScheduleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ScalingPlanPersonalScheduleResource.CreateResourceIdentifier" /> to create a <see cref="ScalingPlanPersonalScheduleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ScalingPlanPersonalScheduleResource"/> object. </returns>
        public virtual ScalingPlanPersonalScheduleResource GetScalingPlanPersonalScheduleResource(ResourceIdentifier id)
        {
            ScalingPlanPersonalScheduleResource.ValidateResourceId(id);
            return new ScalingPlanPersonalScheduleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="VirtualApplicationGroupResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="VirtualApplicationGroupResource.CreateResourceIdentifier" /> to create a <see cref="VirtualApplicationGroupResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="VirtualApplicationGroupResource"/> object. </returns>
        public virtual VirtualApplicationGroupResource GetVirtualApplicationGroupResource(ResourceIdentifier id)
        {
            VirtualApplicationGroupResource.ValidateResourceId(id);
            return new VirtualApplicationGroupResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="VirtualApplicationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="VirtualApplicationResource.CreateResourceIdentifier" /> to create a <see cref="VirtualApplicationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="VirtualApplicationResource"/> object. </returns>
        public virtual VirtualApplicationResource GetVirtualApplicationResource(ResourceIdentifier id)
        {
            VirtualApplicationResource.ValidateResourceId(id);
            return new VirtualApplicationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="VirtualDesktopResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="VirtualDesktopResource.CreateResourceIdentifier" /> to create a <see cref="VirtualDesktopResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="VirtualDesktopResource"/> object. </returns>
        public virtual VirtualDesktopResource GetVirtualDesktopResource(ResourceIdentifier id)
        {
            VirtualDesktopResource.ValidateResourceId(id);
            return new VirtualDesktopResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="HostPoolResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="HostPoolResource.CreateResourceIdentifier" /> to create a <see cref="HostPoolResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="HostPoolResource"/> object. </returns>
        public virtual HostPoolResource GetHostPoolResource(ResourceIdentifier id)
        {
            HostPoolResource.ValidateResourceId(id);
            return new HostPoolResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="UserSessionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="UserSessionResource.CreateResourceIdentifier" /> to create an <see cref="UserSessionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="UserSessionResource"/> object. </returns>
        public virtual UserSessionResource GetUserSessionResource(ResourceIdentifier id)
        {
            UserSessionResource.ValidateResourceId(id);
            return new UserSessionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SessionHostResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SessionHostResource.CreateResourceIdentifier" /> to create a <see cref="SessionHostResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SessionHostResource"/> object. </returns>
        public virtual SessionHostResource GetSessionHostResource(ResourceIdentifier id)
        {
            SessionHostResource.ValidateResourceId(id);
            return new SessionHostResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="MsixPackageResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="MsixPackageResource.CreateResourceIdentifier" /> to create a <see cref="MsixPackageResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="MsixPackageResource"/> object. </returns>
        public virtual MsixPackageResource GetMsixPackageResource(ResourceIdentifier id)
        {
            MsixPackageResource.ValidateResourceId(id);
            return new MsixPackageResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="AppAttachPackageResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="AppAttachPackageResource.CreateResourceIdentifier" /> to create an <see cref="AppAttachPackageResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="AppAttachPackageResource"/> object. </returns>
        public virtual AppAttachPackageResource GetAppAttachPackageResource(ResourceIdentifier id)
        {
            AppAttachPackageResource.ValidateResourceId(id);
            return new AppAttachPackageResource(Client, id);
        }
    }
}
