// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.DesktopVirtualization.Models;

namespace Azure.ResourceManager.DesktopVirtualization.Samples
{
    public partial class Sample_UserSessionResource
    {
        // UserSession_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_UserSessionGet()
        {
            // Generated from example definition: specification/desktopvirtualization/resource-manager/Microsoft.DesktopVirtualization/stable/2024-04-03/examples/UserSession_Get.json
            // this example is just showing the usage of "UserSessions_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this UserSessionResource created on azure
            // for more information of creating UserSessionResource, please refer to the document of UserSessionResource
            string subscriptionId = "daefabc0-95b4-48b3-b645-8a753a63c4fa";
            string resourceGroupName = "resourceGroup1";
            string hostPoolName = "hostPool1";
            string sessionHostName = "sessionHost1.microsoft.com";
            string userSessionId = "1";
            ResourceIdentifier userSessionResourceId = UserSessionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, hostPoolName, sessionHostName, userSessionId);
            UserSessionResource userSession = client.GetUserSessionResource(userSessionResourceId);

            // invoke the operation
            UserSessionResource result = await userSession.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            UserSessionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // UserSession_Delete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_UserSessionDelete()
        {
            // Generated from example definition: specification/desktopvirtualization/resource-manager/Microsoft.DesktopVirtualization/stable/2024-04-03/examples/UserSession_Delete.json
            // this example is just showing the usage of "UserSessions_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this UserSessionResource created on azure
            // for more information of creating UserSessionResource, please refer to the document of UserSessionResource
            string subscriptionId = "daefabc0-95b4-48b3-b645-8a753a63c4fa";
            string resourceGroupName = "resourceGroup1";
            string hostPoolName = "hostPool1";
            string sessionHostName = "sessionHost1.microsoft.com";
            string userSessionId = "1";
            ResourceIdentifier userSessionResourceId = UserSessionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, hostPoolName, sessionHostName, userSessionId);
            UserSessionResource userSession = client.GetUserSessionResource(userSessionResourceId);

            // invoke the operation
            bool? force = true;
            await userSession.DeleteAsync(WaitUntil.Completed, force: force);

            Console.WriteLine($"Succeeded");
        }

        // UserSession_Disconnect_Post
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Disconnect_UserSessionDisconnectPost()
        {
            // Generated from example definition: specification/desktopvirtualization/resource-manager/Microsoft.DesktopVirtualization/stable/2024-04-03/examples/UserSession_Disconnect_Post.json
            // this example is just showing the usage of "UserSessions_Disconnect" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this UserSessionResource created on azure
            // for more information of creating UserSessionResource, please refer to the document of UserSessionResource
            string subscriptionId = "daefabc0-95b4-48b3-b645-8a753a63c4fa";
            string resourceGroupName = "resourceGroup1";
            string hostPoolName = "hostPool1";
            string sessionHostName = "sessionHost1.microsoft.com";
            string userSessionId = "1";
            ResourceIdentifier userSessionResourceId = UserSessionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, hostPoolName, sessionHostName, userSessionId);
            UserSessionResource userSession = client.GetUserSessionResource(userSessionResourceId);

            // invoke the operation
            await userSession.DisconnectAsync();

            Console.WriteLine($"Succeeded");
        }

        // UserSession_SendMessage_Post
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task SendMessage_UserSessionSendMessagePost()
        {
            // Generated from example definition: specification/desktopvirtualization/resource-manager/Microsoft.DesktopVirtualization/stable/2024-04-03/examples/UserSession_SendMessage_Post.json
            // this example is just showing the usage of "UserSessions_SendMessage" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this UserSessionResource created on azure
            // for more information of creating UserSessionResource, please refer to the document of UserSessionResource
            string subscriptionId = "daefabc0-95b4-48b3-b645-8a753a63c4fa";
            string resourceGroupName = "resourceGroup1";
            string hostPoolName = "hostPool1";
            string sessionHostName = "sessionHost1.microsoft.com";
            string userSessionId = "1";
            ResourceIdentifier userSessionResourceId = UserSessionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, hostPoolName, sessionHostName, userSessionId);
            UserSessionResource userSession = client.GetUserSessionResource(userSessionResourceId);

            // invoke the operation
            UserSessionMessage sendMessage = new UserSessionMessage()
            {
                MessageTitle = "title",
                MessageBody = "body",
            };
            await userSession.SendMessageAsync(sendMessage: sendMessage);

            Console.WriteLine($"Succeeded");
        }
    }
}
