// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.DesktopVirtualization.Models;

namespace Azure.ResourceManager.DesktopVirtualization.Samples
{
    public partial class Sample_HostPoolPrivateEndpointConnectionResource
    {
        // PrivateEndpointConnection_GetByHostPool
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_PrivateEndpointConnectionGetByHostPool()
        {
            // Generated from example definition: specification/desktopvirtualization/resource-manager/Microsoft.DesktopVirtualization/stable/2024-04-03/examples/PrivateEndpointConnection_GetByHostPool.json
            // this example is just showing the usage of "PrivateEndpointConnections_GetByHostPool" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this HostPoolPrivateEndpointConnectionResource created on azure
            // for more information of creating HostPoolPrivateEndpointConnectionResource, please refer to the document of HostPoolPrivateEndpointConnectionResource
            string subscriptionId = "daefabc0-95b4-48b3-b645-8a753a63c4fa";
            string resourceGroupName = "resourceGroup1";
            string hostPoolName = "hostPool1";
            string privateEndpointConnectionName = "hostPool1.377103f1-5179-4bdf-8556-4cdd3207cc5b";
            ResourceIdentifier hostPoolPrivateEndpointConnectionResourceId = HostPoolPrivateEndpointConnectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, hostPoolName, privateEndpointConnectionName);
            HostPoolPrivateEndpointConnectionResource hostPoolPrivateEndpointConnection = client.GetHostPoolPrivateEndpointConnectionResource(hostPoolPrivateEndpointConnectionResourceId);

            // invoke the operation
            HostPoolPrivateEndpointConnectionResource result = await hostPoolPrivateEndpointConnection.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DesktopVirtualizationPrivateEndpointConnectionDataData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // PrivateEndpointConnection_DeleteByHostPool
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_PrivateEndpointConnectionDeleteByHostPool()
        {
            // Generated from example definition: specification/desktopvirtualization/resource-manager/Microsoft.DesktopVirtualization/stable/2024-04-03/examples/PrivateEndpointConnection_DeleteByHostPool.json
            // this example is just showing the usage of "PrivateEndpointConnections_DeleteByHostPool" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this HostPoolPrivateEndpointConnectionResource created on azure
            // for more information of creating HostPoolPrivateEndpointConnectionResource, please refer to the document of HostPoolPrivateEndpointConnectionResource
            string subscriptionId = "daefabc0-95b4-48b3-b645-8a753a63c4fa";
            string resourceGroupName = "resourceGroup1";
            string hostPoolName = "hostPool1";
            string privateEndpointConnectionName = "hostPool1.377103f1-5179-4bdf-8556-4cdd3207cc5b";
            ResourceIdentifier hostPoolPrivateEndpointConnectionResourceId = HostPoolPrivateEndpointConnectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, hostPoolName, privateEndpointConnectionName);
            HostPoolPrivateEndpointConnectionResource hostPoolPrivateEndpointConnection = client.GetHostPoolPrivateEndpointConnectionResource(hostPoolPrivateEndpointConnectionResourceId);

            // invoke the operation
            await hostPoolPrivateEndpointConnection.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // PrivateEndpointConnection_UpdateByHostPool
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_PrivateEndpointConnectionUpdateByHostPool()
        {
            // Generated from example definition: specification/desktopvirtualization/resource-manager/Microsoft.DesktopVirtualization/stable/2024-04-03/examples/PrivateEndpointConnection_UpdateByHostPool.json
            // this example is just showing the usage of "PrivateEndpointConnections_UpdateByHostPool" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this HostPoolPrivateEndpointConnectionResource created on azure
            // for more information of creating HostPoolPrivateEndpointConnectionResource, please refer to the document of HostPoolPrivateEndpointConnectionResource
            string subscriptionId = "daefabc0-95b4-48b3-b645-8a753a63c4fa";
            string resourceGroupName = "resourceGroup1";
            string hostPoolName = "hostPool1";
            string privateEndpointConnectionName = "hostPool1.377103f1-5179-4bdf-8556-4cdd3207cc5b";
            ResourceIdentifier hostPoolPrivateEndpointConnectionResourceId = HostPoolPrivateEndpointConnectionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, hostPoolName, privateEndpointConnectionName);
            HostPoolPrivateEndpointConnectionResource hostPoolPrivateEndpointConnection = client.GetHostPoolPrivateEndpointConnectionResource(hostPoolPrivateEndpointConnectionResourceId);

            // invoke the operation
            DesktopVirtualizationPrivateEndpointConnection connection = new DesktopVirtualizationPrivateEndpointConnection()
            {
                ConnectionState = new DesktopVirtualizationPrivateLinkServiceConnectionState()
                {
                    Status = DesktopVirtualizationPrivateEndpointServiceConnectionStatus.Approved,
                    Description = "Approved by admin@consoto.com",
                    ActionsRequired = "None",
                },
            };
            ArmOperation<HostPoolPrivateEndpointConnectionResource> lro = await hostPoolPrivateEndpointConnection.UpdateAsync(WaitUntil.Completed, connection);
            HostPoolPrivateEndpointConnectionResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DesktopVirtualizationPrivateEndpointConnectionDataData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
