// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DefenderEasm.Models
{
    /// <summary> Resources provisioning states. </summary>
    public readonly partial struct EasmResourceProvisioningState : IEquatable<EasmResourceProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EasmResourceProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EasmResourceProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string AcceptedValue = "Accepted";
        private const string CreatingValue = "Creating";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string ProvisioningResourcesValue = "ProvisioningResources";
        private const string InstallingApplicationValue = "InstallingApplication";
        private const string ConfiguringApplicationValue = "ConfiguringApplication";
        private const string MigratingApplicationDataValue = "MigratingApplicationData";
        private const string RunningValidationsValue = "RunningValidations";
        private const string CreatingArtifactsValue = "CreatingArtifacts";
        private const string DeletingArtifactsValue = "DeletingArtifacts";

        /// <summary> NotSpecified. </summary>
        public static EasmResourceProvisioningState NotSpecified { get; } = new EasmResourceProvisioningState(NotSpecifiedValue);
        /// <summary> Accepted. </summary>
        public static EasmResourceProvisioningState Accepted { get; } = new EasmResourceProvisioningState(AcceptedValue);
        /// <summary> Creating. </summary>
        public static EasmResourceProvisioningState Creating { get; } = new EasmResourceProvisioningState(CreatingValue);
        /// <summary> Succeeded. </summary>
        public static EasmResourceProvisioningState Succeeded { get; } = new EasmResourceProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static EasmResourceProvisioningState Failed { get; } = new EasmResourceProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static EasmResourceProvisioningState Canceled { get; } = new EasmResourceProvisioningState(CanceledValue);
        /// <summary> ProvisioningResources. </summary>
        public static EasmResourceProvisioningState ProvisioningResources { get; } = new EasmResourceProvisioningState(ProvisioningResourcesValue);
        /// <summary> InstallingApplication. </summary>
        public static EasmResourceProvisioningState InstallingApplication { get; } = new EasmResourceProvisioningState(InstallingApplicationValue);
        /// <summary> ConfiguringApplication. </summary>
        public static EasmResourceProvisioningState ConfiguringApplication { get; } = new EasmResourceProvisioningState(ConfiguringApplicationValue);
        /// <summary> MigratingApplicationData. </summary>
        public static EasmResourceProvisioningState MigratingApplicationData { get; } = new EasmResourceProvisioningState(MigratingApplicationDataValue);
        /// <summary> RunningValidations. </summary>
        public static EasmResourceProvisioningState RunningValidations { get; } = new EasmResourceProvisioningState(RunningValidationsValue);
        /// <summary> CreatingArtifacts. </summary>
        public static EasmResourceProvisioningState CreatingArtifacts { get; } = new EasmResourceProvisioningState(CreatingArtifactsValue);
        /// <summary> DeletingArtifacts. </summary>
        public static EasmResourceProvisioningState DeletingArtifacts { get; } = new EasmResourceProvisioningState(DeletingArtifactsValue);
        /// <summary> Determines if two <see cref="EasmResourceProvisioningState"/> values are the same. </summary>
        public static bool operator ==(EasmResourceProvisioningState left, EasmResourceProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EasmResourceProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(EasmResourceProvisioningState left, EasmResourceProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EasmResourceProvisioningState"/>. </summary>
        public static implicit operator EasmResourceProvisioningState(string value) => new EasmResourceProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EasmResourceProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EasmResourceProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
