// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DefenderEasm
{
    internal class EasmWorkspaceOperationSource : IOperationSource<EasmWorkspaceResource>
    {
        private readonly ArmClient _client;

        internal EasmWorkspaceOperationSource(ArmClient client)
        {
            _client = client;
        }

        EasmWorkspaceResource IOperationSource<EasmWorkspaceResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = EasmWorkspaceData.DeserializeEasmWorkspaceData(document.RootElement);
            return new EasmWorkspaceResource(_client, data);
        }

        async ValueTask<EasmWorkspaceResource> IOperationSource<EasmWorkspaceResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = EasmWorkspaceData.DeserializeEasmWorkspaceData(document.RootElement);
            return new EasmWorkspaceResource(_client, data);
        }
    }
}
