// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DefenderEasm
{
    internal class EasmLabelOperationSource : IOperationSource<EasmLabelResource>
    {
        private readonly ArmClient _client;

        internal EasmLabelOperationSource(ArmClient client)
        {
            _client = client;
        }

        EasmLabelResource IOperationSource<EasmLabelResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = EasmLabelData.DeserializeEasmLabelData(document.RootElement);
            return new EasmLabelResource(_client, data);
        }

        async ValueTask<EasmLabelResource> IOperationSource<EasmLabelResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = EasmLabelData.DeserializeEasmLabelData(document.RootElement);
            return new EasmLabelResource(_client, data);
        }
    }
}
