// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.DefenderEasm.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableDefenderEasmArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableDefenderEasmArmClient"/> class for mocking. </summary>
        protected MockableDefenderEasmArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableDefenderEasmArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableDefenderEasmArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableDefenderEasmArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing an <see cref="EasmWorkspaceResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="EasmWorkspaceResource.CreateResourceIdentifier" /> to create an <see cref="EasmWorkspaceResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="EasmWorkspaceResource"/> object. </returns>
        public virtual EasmWorkspaceResource GetEasmWorkspaceResource(ResourceIdentifier id)
        {
            EasmWorkspaceResource.ValidateResourceId(id);
            return new EasmWorkspaceResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="EasmLabelResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="EasmLabelResource.CreateResourceIdentifier" /> to create an <see cref="EasmLabelResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="EasmLabelResource"/> object. </returns>
        public virtual EasmLabelResource GetEasmLabelResource(ResourceIdentifier id)
        {
            EasmLabelResource.ValidateResourceId(id);
            return new EasmLabelResource(Client, id);
        }
    }
}
