// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.DefenderEasm.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmDefenderEasmModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="DefenderEasm.EasmWorkspaceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="provisioningState"> Resource provisioning state. </param>
        /// <param name="dataPlaneEndpoint"> Data plane endpoint. </param>
        /// <returns> A new <see cref="DefenderEasm.EasmWorkspaceData"/> instance for mocking. </returns>
        public static EasmWorkspaceData EasmWorkspaceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, EasmResourceProvisioningState? provisioningState = null, string dataPlaneEndpoint = null)
        {
            tags ??= new Dictionary<string, string>();

            return new EasmWorkspaceData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                provisioningState,
                dataPlaneEndpoint,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.EasmWorkspacePatch"/>. </summary>
        /// <param name="tags"> resource tags. </param>
        /// <param name="systemData"> Metadata pertaining to creation and last modification of the resource. </param>
        /// <returns> A new <see cref="Models.EasmWorkspacePatch"/> instance for mocking. </returns>
        public static EasmWorkspacePatch EasmWorkspacePatch(IDictionary<string, string> tags = null, SystemData systemData = null)
        {
            tags ??= new Dictionary<string, string>();

            return new EasmWorkspacePatch(tags, systemData, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DefenderEasm.EasmLabelData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="provisioningState"> Resource provisioning state. </param>
        /// <param name="displayName"> Label display name. </param>
        /// <param name="color"> Label color. </param>
        /// <returns> A new <see cref="DefenderEasm.EasmLabelData"/> instance for mocking. </returns>
        public static EasmLabelData EasmLabelData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, EasmResourceProvisioningState? provisioningState = null, string displayName = null, string color = null)
        {
            return new EasmLabelData(
                id,
                name,
                resourceType,
                systemData,
                provisioningState,
                displayName,
                color,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.EasmLabelPatch"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="provisioningState"> Resource provisioning state. </param>
        /// <param name="displayName"> Label display name. </param>
        /// <param name="color"> Label color. </param>
        /// <returns> A new <see cref="Models.EasmLabelPatch"/> instance for mocking. </returns>
        public static EasmLabelPatch EasmLabelPatch(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, EasmResourceProvisioningState? provisioningState = null, string displayName = null, string color = null)
        {
            return new EasmLabelPatch(
                id,
                name,
                resourceType,
                systemData,
                provisioningState,
                displayName,
                color,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.EasmTask"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="provisioningState"> Resource provisioning state. </param>
        /// <param name="startedAt"> The time the task started. </param>
        /// <param name="completedAt"> The time the task completed. </param>
        /// <param name="lastPolledAt"> The last time the task was polled. </param>
        /// <param name="state"> the state the task is in. </param>
        /// <param name="phase"> the phase the task is in. </param>
        /// <param name="reason"> The reason the task was moved into its current state, if the task wasn't completed. </param>
        /// <param name="metadata"> The reason the task was moved into its current state, if the task wasn't completed. </param>
        /// <returns> A new <see cref="Models.EasmTask"/> instance for mocking. </returns>
        public static EasmTask EasmTask(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, EasmResourceProvisioningState? provisioningState = null, string startedAt = null, string completedAt = null, string lastPolledAt = null, string state = null, string phase = null, string reason = null, BinaryData metadata = null)
        {
            return new EasmTask(
                id,
                name,
                resourceType,
                systemData,
                provisioningState,
                startedAt,
                completedAt,
                lastPolledAt,
                state,
                phase,
                reason,
                metadata,
                serializedAdditionalRawData: null);
        }
    }
}
