// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.DataShare.Models;

namespace Azure.ResourceManager.DataShare
{
    public partial class ShareDataSetMappingData : IUtf8JsonSerializable, IJsonModel<ShareDataSetMappingData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ShareDataSetMappingData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ShareDataSetMappingData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ShareDataSetMappingData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ShareDataSetMappingData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("kind"u8);
            writer.WriteStringValue(Kind.ToString());
        }

        ShareDataSetMappingData IJsonModel<ShareDataSetMappingData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ShareDataSetMappingData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ShareDataSetMappingData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeShareDataSetMappingData(document.RootElement, options);
        }

        internal static ShareDataSetMappingData DeserializeShareDataSetMappingData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            if (element.TryGetProperty("kind", out JsonElement discriminator))
            {
                switch (discriminator.GetString())
                {
                    case "AdlsGen2File": return AdlsGen2FileDataSetMapping.DeserializeAdlsGen2FileDataSetMapping(element, options);
                    case "AdlsGen2FileSystem": return AdlsGen2FileSystemDataSetMapping.DeserializeAdlsGen2FileSystemDataSetMapping(element, options);
                    case "AdlsGen2Folder": return AdlsGen2FolderDataSetMapping.DeserializeAdlsGen2FolderDataSetMapping(element, options);
                    case "Blob": return BlobDataSetMapping.DeserializeBlobDataSetMapping(element, options);
                    case "BlobFolder": return BlobFolderDataSetMapping.DeserializeBlobFolderDataSetMapping(element, options);
                    case "Container": return BlobContainerDataSetMapping.DeserializeBlobContainerDataSetMapping(element, options);
                    case "KustoCluster": return KustoClusterDataSetMapping.DeserializeKustoClusterDataSetMapping(element, options);
                    case "KustoDatabase": return KustoDatabaseDataSetMapping.DeserializeKustoDatabaseDataSetMapping(element, options);
                    case "KustoTable": return KustoTableDataSetMapping.DeserializeKustoTableDataSetMapping(element, options);
                    case "SqlDBTable": return SqlDBTableDataSetMapping.DeserializeSqlDBTableDataSetMapping(element, options);
                    case "SqlDWTable": return SqlDWTableDataSetMapping.DeserializeSqlDWTableDataSetMapping(element, options);
                    case "SynapseWorkspaceSqlPoolTable": return SynapseWorkspaceSqlPoolTableDataSetMapping.DeserializeSynapseWorkspaceSqlPoolTableDataSetMapping(element, options);
                }
            }
            return UnknownDataSetMapping.DeserializeUnknownDataSetMapping(element, options);
        }

        BinaryData IPersistableModel<ShareDataSetMappingData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ShareDataSetMappingData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ShareDataSetMappingData)} does not support writing '{options.Format}' format.");
            }
        }

        ShareDataSetMappingData IPersistableModel<ShareDataSetMappingData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ShareDataSetMappingData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeShareDataSetMappingData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ShareDataSetMappingData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ShareDataSetMappingData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
