// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.DataShare.Models;

namespace Azure.ResourceManager.DataShare
{
    public partial class ShareDataSetData : IUtf8JsonSerializable, IJsonModel<ShareDataSetData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ShareDataSetData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ShareDataSetData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ShareDataSetData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ShareDataSetData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("kind"u8);
            writer.WriteStringValue(Kind.ToString());
        }

        ShareDataSetData IJsonModel<ShareDataSetData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ShareDataSetData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ShareDataSetData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeShareDataSetData(document.RootElement, options);
        }

        internal static ShareDataSetData DeserializeShareDataSetData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            if (element.TryGetProperty("kind", out JsonElement discriminator))
            {
                switch (discriminator.GetString())
                {
                    case "AdlsGen1File": return AdlsGen1FileDataSet.DeserializeAdlsGen1FileDataSet(element, options);
                    case "AdlsGen1Folder": return AdlsGen1FolderDataSet.DeserializeAdlsGen1FolderDataSet(element, options);
                    case "AdlsGen2File": return AdlsGen2FileDataSet.DeserializeAdlsGen2FileDataSet(element, options);
                    case "AdlsGen2FileSystem": return AdlsGen2FileSystemDataSet.DeserializeAdlsGen2FileSystemDataSet(element, options);
                    case "AdlsGen2Folder": return AdlsGen2FolderDataSet.DeserializeAdlsGen2FolderDataSet(element, options);
                    case "Blob": return BlobDataSet.DeserializeBlobDataSet(element, options);
                    case "BlobFolder": return BlobFolderDataSet.DeserializeBlobFolderDataSet(element, options);
                    case "Container": return BlobContainerDataSet.DeserializeBlobContainerDataSet(element, options);
                    case "KustoCluster": return KustoClusterDataSet.DeserializeKustoClusterDataSet(element, options);
                    case "KustoDatabase": return KustoDatabaseDataSet.DeserializeKustoDatabaseDataSet(element, options);
                    case "KustoTable": return KustoTableDataSet.DeserializeKustoTableDataSet(element, options);
                    case "SqlDBTable": return SqlDBTableDataSet.DeserializeSqlDBTableDataSet(element, options);
                    case "SqlDWTable": return SqlDWTableDataSet.DeserializeSqlDWTableDataSet(element, options);
                    case "SynapseWorkspaceSqlPoolTable": return SynapseWorkspaceSqlPoolTableDataSet.DeserializeSynapseWorkspaceSqlPoolTableDataSet(element, options);
                }
            }
            return UnknownDataSet.DeserializeUnknownDataSet(element, options);
        }

        BinaryData IPersistableModel<ShareDataSetData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ShareDataSetData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ShareDataSetData)} does not support writing '{options.Format}' format.");
            }
        }

        ShareDataSetData IPersistableModel<ShareDataSetData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ShareDataSetData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeShareDataSetData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ShareDataSetData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ShareDataSetData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
