// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.DataShare.Models;

namespace Azure.ResourceManager.DataShare
{
    internal partial class EmailRegistrationsRestOperations
    {
        private readonly TelemetryDetails _userAgent;
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;
        private readonly string _apiVersion;

        /// <summary> Initializes a new instance of EmailRegistrationsRestOperations. </summary>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="applicationId"> The application id to use for user agent. </param>
        /// <param name="endpoint"> server parameter. </param>
        /// <param name="apiVersion"> Api Version. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="pipeline"/> or <paramref name="apiVersion"/> is null. </exception>
        public EmailRegistrationsRestOperations(HttpPipeline pipeline, string applicationId, Uri endpoint = null, string apiVersion = default)
        {
            _pipeline = pipeline ?? throw new ArgumentNullException(nameof(pipeline));
            _endpoint = endpoint ?? new Uri("https://management.azure.com");
            _apiVersion = apiVersion ?? "2021-08-01";
            _userAgent = new TelemetryDetails(GetType().Assembly, applicationId);
        }

        internal RequestUriBuilder CreateActivateEmailRequestUri(AzureLocation location, DataShareEmailRegistration emailRegistration)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.DataShare/locations/", false);
            uri.AppendPath(location, true);
            uri.AppendPath("/activateEmail", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateActivateEmailRequest(AzureLocation location, DataShareEmailRegistration emailRegistration)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.DataShare/locations/", false);
            uri.AppendPath(location, true);
            uri.AppendPath("/activateEmail", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(emailRegistration, ModelSerializationExtensions.WireOptions);
            request.Content = content;
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Activate the email registration for the current tenant. </summary>
        /// <param name="location"> Location of the activation. </param>
        /// <param name="emailRegistration"> The payload for tenant domain activation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="emailRegistration"/> is null. </exception>
        public async Task<Response<DataShareEmailRegistration>> ActivateEmailAsync(AzureLocation location, DataShareEmailRegistration emailRegistration, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(emailRegistration, nameof(emailRegistration));

            using var message = CreateActivateEmailRequest(location, emailRegistration);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DataShareEmailRegistration value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = DataShareEmailRegistration.DeserializeDataShareEmailRegistration(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Activate the email registration for the current tenant. </summary>
        /// <param name="location"> Location of the activation. </param>
        /// <param name="emailRegistration"> The payload for tenant domain activation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="emailRegistration"/> is null. </exception>
        public Response<DataShareEmailRegistration> ActivateEmail(AzureLocation location, DataShareEmailRegistration emailRegistration, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(emailRegistration, nameof(emailRegistration));

            using var message = CreateActivateEmailRequest(location, emailRegistration);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DataShareEmailRegistration value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = DataShareEmailRegistration.DeserializeDataShareEmailRegistration(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateRegisterEmailRequestUri(AzureLocation location)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.DataShare/locations/", false);
            uri.AppendPath(location, true);
            uri.AppendPath("/registerEmail", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateRegisterEmailRequest(AzureLocation location)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.DataShare/locations/", false);
            uri.AppendPath(location, true);
            uri.AppendPath("/registerEmail", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Register an email for the current tenant. </summary>
        /// <param name="location"> Location of the registration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response<DataShareEmailRegistration>> RegisterEmailAsync(AzureLocation location, CancellationToken cancellationToken = default)
        {
            using var message = CreateRegisterEmailRequest(location);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DataShareEmailRegistration value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = DataShareEmailRegistration.DeserializeDataShareEmailRegistration(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Register an email for the current tenant. </summary>
        /// <param name="location"> Location of the registration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response<DataShareEmailRegistration> RegisterEmail(AzureLocation location, CancellationToken cancellationToken = default)
        {
            using var message = CreateRegisterEmailRequest(location);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DataShareEmailRegistration value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = DataShareEmailRegistration.DeserializeDataShareEmailRegistration(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }
    }
}
