// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.DataShare
{
    /// <summary>
    /// A Class representing a ProviderShareSubscription along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct a <see cref="ProviderShareSubscriptionResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetProviderShareSubscriptionResource method.
    /// Otherwise you can get one from its parent resource <see cref="DataShareResource"/> using the GetProviderShareSubscription method.
    /// </summary>
    public partial class ProviderShareSubscriptionResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="ProviderShareSubscriptionResource"/> instance. </summary>
        /// <param name="subscriptionId"> The subscriptionId. </param>
        /// <param name="resourceGroupName"> The resourceGroupName. </param>
        /// <param name="accountName"> The accountName. </param>
        /// <param name="shareName"> The shareName. </param>
        /// <param name="providerShareSubscriptionId"> The providerShareSubscriptionId. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string subscriptionId, string resourceGroupName, string accountName, string shareName, string providerShareSubscriptionId)
        {
            var resourceId = $"/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shares/{shareName}/providerShareSubscriptions/{providerShareSubscriptionId}";
            return new ResourceIdentifier(resourceId);
        }

        private readonly ClientDiagnostics _providerShareSubscriptionClientDiagnostics;
        private readonly ProviderShareSubscriptionsRestOperations _providerShareSubscriptionRestClient;
        private readonly ProviderShareSubscriptionData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Microsoft.DataShare/accounts/shares/providerShareSubscriptions";

        /// <summary> Initializes a new instance of the <see cref="ProviderShareSubscriptionResource"/> class for mocking. </summary>
        protected ProviderShareSubscriptionResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="ProviderShareSubscriptionResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal ProviderShareSubscriptionResource(ArmClient client, ProviderShareSubscriptionData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="ProviderShareSubscriptionResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal ProviderShareSubscriptionResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _providerShareSubscriptionClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.DataShare", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string providerShareSubscriptionApiVersion);
            _providerShareSubscriptionRestClient = new ProviderShareSubscriptionsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, providerShareSubscriptionApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual ProviderShareSubscriptionData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary>
        /// Get share subscription in a provider share
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shares/{shareName}/providerShareSubscriptions/{providerShareSubscriptionId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ProviderShareSubscriptions_GetByShare</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ProviderShareSubscriptionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<ProviderShareSubscriptionResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _providerShareSubscriptionClientDiagnostics.CreateScope("ProviderShareSubscriptionResource.Get");
            scope.Start();
            try
            {
                var response = await _providerShareSubscriptionRestClient.GetByShareAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ProviderShareSubscriptionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get share subscription in a provider share
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shares/{shareName}/providerShareSubscriptions/{providerShareSubscriptionId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ProviderShareSubscriptions_GetByShare</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ProviderShareSubscriptionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<ProviderShareSubscriptionResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _providerShareSubscriptionClientDiagnostics.CreateScope("ProviderShareSubscriptionResource.Get");
            scope.Start();
            try
            {
                var response = _providerShareSubscriptionRestClient.GetByShare(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ProviderShareSubscriptionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Adjust a share subscription's expiration date in a provider share
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shares/{shareName}/providerShareSubscriptions/{providerShareSubscriptionId}/adjust</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ProviderShareSubscriptions_Adjust</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ProviderShareSubscriptionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="data"> The provider share subscription. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual async Task<Response<ProviderShareSubscriptionResource>> AdjustAsync(ProviderShareSubscriptionData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _providerShareSubscriptionClientDiagnostics.CreateScope("ProviderShareSubscriptionResource.Adjust");
            scope.Start();
            try
            {
                var response = await _providerShareSubscriptionRestClient.AdjustAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, data, cancellationToken).ConfigureAwait(false);
                return Response.FromValue(new ProviderShareSubscriptionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Adjust a share subscription's expiration date in a provider share
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shares/{shareName}/providerShareSubscriptions/{providerShareSubscriptionId}/adjust</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ProviderShareSubscriptions_Adjust</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ProviderShareSubscriptionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="data"> The provider share subscription. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual Response<ProviderShareSubscriptionResource> Adjust(ProviderShareSubscriptionData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _providerShareSubscriptionClientDiagnostics.CreateScope("ProviderShareSubscriptionResource.Adjust");
            scope.Start();
            try
            {
                var response = _providerShareSubscriptionRestClient.Adjust(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, data, cancellationToken);
                return Response.FromValue(new ProviderShareSubscriptionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Reinstate share subscription in a provider share
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shares/{shareName}/providerShareSubscriptions/{providerShareSubscriptionId}/reinstate</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ProviderShareSubscriptions_Reinstate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ProviderShareSubscriptionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="data"> The provider share subscription. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual async Task<Response<ProviderShareSubscriptionResource>> ReinstateAsync(ProviderShareSubscriptionData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _providerShareSubscriptionClientDiagnostics.CreateScope("ProviderShareSubscriptionResource.Reinstate");
            scope.Start();
            try
            {
                var response = await _providerShareSubscriptionRestClient.ReinstateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, data, cancellationToken).ConfigureAwait(false);
                return Response.FromValue(new ProviderShareSubscriptionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Reinstate share subscription in a provider share
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shares/{shareName}/providerShareSubscriptions/{providerShareSubscriptionId}/reinstate</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ProviderShareSubscriptions_Reinstate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ProviderShareSubscriptionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="data"> The provider share subscription. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual Response<ProviderShareSubscriptionResource> Reinstate(ProviderShareSubscriptionData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _providerShareSubscriptionClientDiagnostics.CreateScope("ProviderShareSubscriptionResource.Reinstate");
            scope.Start();
            try
            {
                var response = _providerShareSubscriptionRestClient.Reinstate(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, data, cancellationToken);
                return Response.FromValue(new ProviderShareSubscriptionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Revoke share subscription in a provider share
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shares/{shareName}/providerShareSubscriptions/{providerShareSubscriptionId}/revoke</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ProviderShareSubscriptions_Revoke</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ProviderShareSubscriptionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<ArmOperation<ProviderShareSubscriptionResource>> RevokeAsync(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _providerShareSubscriptionClientDiagnostics.CreateScope("ProviderShareSubscriptionResource.Revoke");
            scope.Start();
            try
            {
                var response = await _providerShareSubscriptionRestClient.RevokeAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, cancellationToken).ConfigureAwait(false);
                var operation = new DataShareArmOperation<ProviderShareSubscriptionResource>(new ProviderShareSubscriptionOperationSource(Client), _providerShareSubscriptionClientDiagnostics, Pipeline, _providerShareSubscriptionRestClient.CreateRevokeRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Revoke share subscription in a provider share
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shares/{shareName}/providerShareSubscriptions/{providerShareSubscriptionId}/revoke</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ProviderShareSubscriptions_Revoke</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ProviderShareSubscriptionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual ArmOperation<ProviderShareSubscriptionResource> Revoke(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _providerShareSubscriptionClientDiagnostics.CreateScope("ProviderShareSubscriptionResource.Revoke");
            scope.Start();
            try
            {
                var response = _providerShareSubscriptionRestClient.Revoke(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, cancellationToken);
                var operation = new DataShareArmOperation<ProviderShareSubscriptionResource>(new ProviderShareSubscriptionOperationSource(Client), _providerShareSubscriptionClientDiagnostics, Pipeline, _providerShareSubscriptionRestClient.CreateRevokeRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
