// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.DataShare.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.DataShare
{
    public partial class ProviderShareSubscriptionData : IUtf8JsonSerializable, IJsonModel<ProviderShareSubscriptionData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ProviderShareSubscriptionData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ProviderShareSubscriptionData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ProviderShareSubscriptionData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ProviderShareSubscriptionData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (options.Format != "W" && Optional.IsDefined(ConsumerEmail))
            {
                writer.WritePropertyName("consumerEmail"u8);
                writer.WriteStringValue(ConsumerEmail);
            }
            if (options.Format != "W" && Optional.IsDefined(ConsumerName))
            {
                writer.WritePropertyName("consumerName"u8);
                writer.WriteStringValue(ConsumerName);
            }
            if (options.Format != "W" && Optional.IsDefined(ConsumerTenantName))
            {
                writer.WritePropertyName("consumerTenantName"u8);
                writer.WriteStringValue(ConsumerTenantName);
            }
            if (options.Format != "W" && Optional.IsDefined(CreatedOn))
            {
                writer.WritePropertyName("createdAt"u8);
                writer.WriteStringValue(CreatedOn.Value, "O");
            }
            if (Optional.IsDefined(ExpireOn))
            {
                writer.WritePropertyName("expirationDate"u8);
                writer.WriteStringValue(ExpireOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(ProviderEmail))
            {
                writer.WritePropertyName("providerEmail"u8);
                writer.WriteStringValue(ProviderEmail);
            }
            if (options.Format != "W" && Optional.IsDefined(ProviderName))
            {
                writer.WritePropertyName("providerName"u8);
                writer.WriteStringValue(ProviderName);
            }
            if (options.Format != "W" && Optional.IsDefined(SharedOn))
            {
                writer.WritePropertyName("sharedAt"u8);
                writer.WriteStringValue(SharedOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(ShareSubscriptionObjectId))
            {
                writer.WritePropertyName("shareSubscriptionObjectId"u8);
                writer.WriteStringValue(ShareSubscriptionObjectId);
            }
            if (options.Format != "W" && Optional.IsDefined(ShareSubscriptionStatus))
            {
                writer.WritePropertyName("shareSubscriptionStatus"u8);
                writer.WriteStringValue(ShareSubscriptionStatus.Value.ToString());
            }
            writer.WriteEndObject();
        }

        ProviderShareSubscriptionData IJsonModel<ProviderShareSubscriptionData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ProviderShareSubscriptionData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ProviderShareSubscriptionData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeProviderShareSubscriptionData(document.RootElement, options);
        }

        internal static ProviderShareSubscriptionData DeserializeProviderShareSubscriptionData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            string consumerEmail = default;
            string consumerName = default;
            string consumerTenantName = default;
            DateTimeOffset? createdAt = default;
            DateTimeOffset? expirationDate = default;
            string providerEmail = default;
            string providerName = default;
            DateTimeOffset? sharedAt = default;
            string shareSubscriptionObjectId = default;
            ShareSubscriptionStatus? shareSubscriptionStatus = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("consumerEmail"u8))
                        {
                            consumerEmail = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("consumerName"u8))
                        {
                            consumerName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("consumerTenantName"u8))
                        {
                            consumerTenantName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("createdAt"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            createdAt = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("expirationDate"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            expirationDate = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("providerEmail"u8))
                        {
                            providerEmail = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("providerName"u8))
                        {
                            providerName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("sharedAt"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            sharedAt = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("shareSubscriptionObjectId"u8))
                        {
                            shareSubscriptionObjectId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("shareSubscriptionStatus"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            shareSubscriptionStatus = new ShareSubscriptionStatus(property0.Value.GetString());
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ProviderShareSubscriptionData(
                id,
                name,
                type,
                systemData,
                consumerEmail,
                consumerName,
                consumerTenantName,
                createdAt,
                expirationDate,
                providerEmail,
                providerName,
                sharedAt,
                shareSubscriptionObjectId,
                shareSubscriptionStatus,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ProviderShareSubscriptionData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ProviderShareSubscriptionData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ProviderShareSubscriptionData)} does not support writing '{options.Format}' format.");
            }
        }

        ProviderShareSubscriptionData IPersistableModel<ProviderShareSubscriptionData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ProviderShareSubscriptionData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeProviderShareSubscriptionData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ProviderShareSubscriptionData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ProviderShareSubscriptionData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
