// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataShare.Models
{
    /// <summary> Kind of synchronization on trigger. </summary>
    internal readonly partial struct TriggerKind : IEquatable<TriggerKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="TriggerKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public TriggerKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ScheduleBasedValue = "ScheduleBased";

        /// <summary> ScheduleBased. </summary>
        public static TriggerKind ScheduleBased { get; } = new TriggerKind(ScheduleBasedValue);
        /// <summary> Determines if two <see cref="TriggerKind"/> values are the same. </summary>
        public static bool operator ==(TriggerKind left, TriggerKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="TriggerKind"/> values are not the same. </summary>
        public static bool operator !=(TriggerKind left, TriggerKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="TriggerKind"/>. </summary>
        public static implicit operator TriggerKind(string value) => new TriggerKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is TriggerKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(TriggerKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
