// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataShare.Models
{
    /// <summary> Table level sharing properties dto for kusto data set properties. </summary>
    public partial class TableLevelSharingProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="TableLevelSharingProperties"/>. </summary>
        public TableLevelSharingProperties()
        {
            ExternalTablesToExclude = new ChangeTrackingList<string>();
            ExternalTablesToInclude = new ChangeTrackingList<string>();
            MaterializedViewsToExclude = new ChangeTrackingList<string>();
            MaterializedViewsToInclude = new ChangeTrackingList<string>();
            TablesToExclude = new ChangeTrackingList<string>();
            TablesToInclude = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="TableLevelSharingProperties"/>. </summary>
        /// <param name="externalTablesToExclude"> External tables to be excluded in the data set. </param>
        /// <param name="externalTablesToInclude"> External tables to be included in the data set. </param>
        /// <param name="materializedViewsToExclude"> Materialized views to be excluded in the data set. </param>
        /// <param name="materializedViewsToInclude"> Materialized views to be included in the data set. </param>
        /// <param name="tablesToExclude"> Tables to be excluded in the data set. </param>
        /// <param name="tablesToInclude"> Tables to be included in the data set. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal TableLevelSharingProperties(IList<string> externalTablesToExclude, IList<string> externalTablesToInclude, IList<string> materializedViewsToExclude, IList<string> materializedViewsToInclude, IList<string> tablesToExclude, IList<string> tablesToInclude, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ExternalTablesToExclude = externalTablesToExclude;
            ExternalTablesToInclude = externalTablesToInclude;
            MaterializedViewsToExclude = materializedViewsToExclude;
            MaterializedViewsToInclude = materializedViewsToInclude;
            TablesToExclude = tablesToExclude;
            TablesToInclude = tablesToInclude;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> External tables to be excluded in the data set. </summary>
        public IList<string> ExternalTablesToExclude { get; }
        /// <summary> External tables to be included in the data set. </summary>
        public IList<string> ExternalTablesToInclude { get; }
        /// <summary> Materialized views to be excluded in the data set. </summary>
        public IList<string> MaterializedViewsToExclude { get; }
        /// <summary> Materialized views to be included in the data set. </summary>
        public IList<string> MaterializedViewsToInclude { get; }
        /// <summary> Tables to be excluded in the data set. </summary>
        public IList<string> TablesToExclude { get; }
        /// <summary> Tables to be included in the data set. </summary>
        public IList<string> TablesToInclude { get; }
    }
}
