// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataShare.Models
{
    /// <summary> Kind of synchronization setting. </summary>
    internal readonly partial struct SynchronizationSettingKind : IEquatable<SynchronizationSettingKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SynchronizationSettingKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SynchronizationSettingKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ScheduleBasedValue = "ScheduleBased";

        /// <summary> ScheduleBased. </summary>
        public static SynchronizationSettingKind ScheduleBased { get; } = new SynchronizationSettingKind(ScheduleBasedValue);
        /// <summary> Determines if two <see cref="SynchronizationSettingKind"/> values are the same. </summary>
        public static bool operator ==(SynchronizationSettingKind left, SynchronizationSettingKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SynchronizationSettingKind"/> values are not the same. </summary>
        public static bool operator !=(SynchronizationSettingKind left, SynchronizationSettingKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SynchronizationSettingKind"/>. </summary>
        public static implicit operator SynchronizationSettingKind(string value) => new SynchronizationSettingKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SynchronizationSettingKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SynchronizationSettingKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
