// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataShare.Models
{
    /// <summary> Synchronization mode. </summary>
    public readonly partial struct SynchronizationMode : IEquatable<SynchronizationMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SynchronizationMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SynchronizationMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IncrementalValue = "Incremental";
        private const string FullSyncValue = "FullSync";

        /// <summary> Incremental. </summary>
        public static SynchronizationMode Incremental { get; } = new SynchronizationMode(IncrementalValue);
        /// <summary> FullSync. </summary>
        public static SynchronizationMode FullSync { get; } = new SynchronizationMode(FullSyncValue);
        /// <summary> Determines if two <see cref="SynchronizationMode"/> values are the same. </summary>
        public static bool operator ==(SynchronizationMode left, SynchronizationMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SynchronizationMode"/> values are not the same. </summary>
        public static bool operator !=(SynchronizationMode left, SynchronizationMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SynchronizationMode"/>. </summary>
        public static implicit operator SynchronizationMode(string value) => new SynchronizationMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SynchronizationMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SynchronizationMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
