// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.DataShare.Models
{
    [PersistableModelProxy(typeof(UnknownSourceShareSynchronizationSetting))]
    public partial class SourceShareSynchronizationSetting : IUtf8JsonSerializable, IJsonModel<SourceShareSynchronizationSetting>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SourceShareSynchronizationSetting>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SourceShareSynchronizationSetting>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SourceShareSynchronizationSetting>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SourceShareSynchronizationSetting)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("kind"u8);
            writer.WriteStringValue(Kind.ToString());
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        SourceShareSynchronizationSetting IJsonModel<SourceShareSynchronizationSetting>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SourceShareSynchronizationSetting>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SourceShareSynchronizationSetting)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSourceShareSynchronizationSetting(document.RootElement, options);
        }

        internal static SourceShareSynchronizationSetting DeserializeSourceShareSynchronizationSetting(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            if (element.TryGetProperty("kind", out JsonElement discriminator))
            {
                switch (discriminator.GetString())
                {
                    case "ScheduleBased": return ScheduledSourceSynchronizationSetting.DeserializeScheduledSourceSynchronizationSetting(element, options);
                }
            }
            return UnknownSourceShareSynchronizationSetting.DeserializeUnknownSourceShareSynchronizationSetting(element, options);
        }

        BinaryData IPersistableModel<SourceShareSynchronizationSetting>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SourceShareSynchronizationSetting>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(SourceShareSynchronizationSetting)} does not support writing '{options.Format}' format.");
            }
        }

        SourceShareSynchronizationSetting IPersistableModel<SourceShareSynchronizationSetting>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SourceShareSynchronizationSetting>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSourceShareSynchronizationSetting(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SourceShareSynchronizationSetting)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SourceShareSynchronizationSetting>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
