// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.DataShare.Models
{
    public partial class ShareSynchronization : IUtf8JsonSerializable, IJsonModel<ShareSynchronization>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ShareSynchronization>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ShareSynchronization>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ShareSynchronization>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ShareSynchronization)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(ConsumerEmail))
            {
                writer.WritePropertyName("consumerEmail"u8);
                writer.WriteStringValue(ConsumerEmail);
            }
            if (Optional.IsDefined(ConsumerName))
            {
                writer.WritePropertyName("consumerName"u8);
                writer.WriteStringValue(ConsumerName);
            }
            if (Optional.IsDefined(ConsumerTenantName))
            {
                writer.WritePropertyName("consumerTenantName"u8);
                writer.WriteStringValue(ConsumerTenantName);
            }
            if (Optional.IsDefined(DurationInMilliSeconds))
            {
                writer.WritePropertyName("durationMs"u8);
                writer.WriteNumberValue(DurationInMilliSeconds.Value);
            }
            if (Optional.IsDefined(EndOn))
            {
                writer.WritePropertyName("endTime"u8);
                writer.WriteStringValue(EndOn.Value, "O");
            }
            if (Optional.IsDefined(Message))
            {
                writer.WritePropertyName("message"u8);
                writer.WriteStringValue(Message);
            }
            if (Optional.IsDefined(StartOn))
            {
                writer.WritePropertyName("startTime"u8);
                writer.WriteStringValue(StartOn.Value, "O");
            }
            if (Optional.IsDefined(Status))
            {
                writer.WritePropertyName("status"u8);
                writer.WriteStringValue(Status);
            }
            if (Optional.IsDefined(SynchronizationId))
            {
                writer.WritePropertyName("synchronizationId"u8);
                writer.WriteStringValue(SynchronizationId.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(SynchronizationMode))
            {
                writer.WritePropertyName("synchronizationMode"u8);
                writer.WriteStringValue(SynchronizationMode.Value.ToString());
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ShareSynchronization IJsonModel<ShareSynchronization>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ShareSynchronization>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ShareSynchronization)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeShareSynchronization(document.RootElement, options);
        }

        internal static ShareSynchronization DeserializeShareSynchronization(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string consumerEmail = default;
            string consumerName = default;
            string consumerTenantName = default;
            int? durationMs = default;
            DateTimeOffset? endTime = default;
            string message = default;
            DateTimeOffset? startTime = default;
            string status = default;
            Guid? synchronizationId = default;
            SynchronizationMode? synchronizationMode = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("consumerEmail"u8))
                {
                    consumerEmail = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("consumerName"u8))
                {
                    consumerName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("consumerTenantName"u8))
                {
                    consumerTenantName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("durationMs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    durationMs = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("endTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    endTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("message"u8))
                {
                    message = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("startTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    startTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("status"u8))
                {
                    status = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("synchronizationId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    synchronizationId = property.Value.GetGuid();
                    continue;
                }
                if (property.NameEquals("synchronizationMode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    synchronizationMode = new SynchronizationMode(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ShareSynchronization(
                consumerEmail,
                consumerName,
                consumerTenantName,
                durationMs,
                endTime,
                message,
                startTime,
                status,
                synchronizationId,
                synchronizationMode,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ShareSynchronization>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ShareSynchronization>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ShareSynchronization)} does not support writing '{options.Format}' format.");
            }
        }

        ShareSynchronization IPersistableModel<ShareSynchronization>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ShareSynchronization>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeShareSynchronization(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ShareSynchronization)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ShareSynchronization>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
