// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataShare.Models
{
    /// <summary> Type of data set. </summary>
    public readonly partial struct ShareDataSetType : IEquatable<ShareDataSetType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ShareDataSetType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ShareDataSetType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BlobValue = "Blob";
        private const string ContainerValue = "Container";
        private const string BlobFolderValue = "BlobFolder";
        private const string AdlsGen2FileSystemValue = "AdlsGen2FileSystem";
        private const string AdlsGen2FolderValue = "AdlsGen2Folder";
        private const string AdlsGen2FileValue = "AdlsGen2File";
        private const string AdlsGen1FolderValue = "AdlsGen1Folder";
        private const string AdlsGen1FileValue = "AdlsGen1File";
        private const string KustoClusterValue = "KustoCluster";
        private const string KustoDatabaseValue = "KustoDatabase";
        private const string KustoTableValue = "KustoTable";
        private const string SqlDBTableValue = "SqlDBTable";
        private const string SqlDWTableValue = "SqlDWTable";
        private const string SynapseWorkspaceSqlPoolTableValue = "SynapseWorkspaceSqlPoolTable";

        /// <summary> Blob. </summary>
        public static ShareDataSetType Blob { get; } = new ShareDataSetType(BlobValue);
        /// <summary> Container. </summary>
        public static ShareDataSetType Container { get; } = new ShareDataSetType(ContainerValue);
        /// <summary> BlobFolder. </summary>
        public static ShareDataSetType BlobFolder { get; } = new ShareDataSetType(BlobFolderValue);
        /// <summary> AdlsGen2FileSystem. </summary>
        public static ShareDataSetType AdlsGen2FileSystem { get; } = new ShareDataSetType(AdlsGen2FileSystemValue);
        /// <summary> AdlsGen2Folder. </summary>
        public static ShareDataSetType AdlsGen2Folder { get; } = new ShareDataSetType(AdlsGen2FolderValue);
        /// <summary> AdlsGen2File. </summary>
        public static ShareDataSetType AdlsGen2File { get; } = new ShareDataSetType(AdlsGen2FileValue);
        /// <summary> AdlsGen1Folder. </summary>
        public static ShareDataSetType AdlsGen1Folder { get; } = new ShareDataSetType(AdlsGen1FolderValue);
        /// <summary> AdlsGen1File. </summary>
        public static ShareDataSetType AdlsGen1File { get; } = new ShareDataSetType(AdlsGen1FileValue);
        /// <summary> KustoCluster. </summary>
        public static ShareDataSetType KustoCluster { get; } = new ShareDataSetType(KustoClusterValue);
        /// <summary> KustoDatabase. </summary>
        public static ShareDataSetType KustoDatabase { get; } = new ShareDataSetType(KustoDatabaseValue);
        /// <summary> KustoTable. </summary>
        public static ShareDataSetType KustoTable { get; } = new ShareDataSetType(KustoTableValue);
        /// <summary> SqlDBTable. </summary>
        public static ShareDataSetType SqlDBTable { get; } = new ShareDataSetType(SqlDBTableValue);
        /// <summary> SqlDWTable. </summary>
        public static ShareDataSetType SqlDWTable { get; } = new ShareDataSetType(SqlDWTableValue);
        /// <summary> SynapseWorkspaceSqlPoolTable. </summary>
        public static ShareDataSetType SynapseWorkspaceSqlPoolTable { get; } = new ShareDataSetType(SynapseWorkspaceSqlPoolTableValue);
        /// <summary> Determines if two <see cref="ShareDataSetType"/> values are the same. </summary>
        public static bool operator ==(ShareDataSetType left, ShareDataSetType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ShareDataSetType"/> values are not the same. </summary>
        public static bool operator !=(ShareDataSetType left, ShareDataSetType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ShareDataSetType"/>. </summary>
        public static implicit operator ShareDataSetType(string value) => new ShareDataSetType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ShareDataSetType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ShareDataSetType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
