// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.DataShare.Models
{
    /// <summary> A type of trigger based on schedule. </summary>
    public partial class ScheduledTrigger : DataShareTriggerData
    {
        /// <summary> Initializes a new instance of <see cref="ScheduledTrigger"/>. </summary>
        /// <param name="recurrenceInterval"> Recurrence Interval. </param>
        /// <param name="synchronizeOn"> Synchronization time. </param>
        public ScheduledTrigger(DataShareSynchronizationRecurrenceInterval recurrenceInterval, DateTimeOffset synchronizeOn)
        {
            RecurrenceInterval = recurrenceInterval;
            SynchronizeOn = synchronizeOn;
            Kind = TriggerKind.ScheduleBased;
        }

        /// <summary> Initializes a new instance of <see cref="ScheduledTrigger"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="kind"> Kind of synchronization on trigger. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="createdOn"> Time at which the trigger was created. </param>
        /// <param name="provisioningState"> Gets the provisioning state. </param>
        /// <param name="recurrenceInterval"> Recurrence Interval. </param>
        /// <param name="synchronizationMode"> Synchronization mode. </param>
        /// <param name="synchronizeOn"> Synchronization time. </param>
        /// <param name="triggerStatus"> Gets the trigger state. </param>
        /// <param name="userName"> Name of the user who created the trigger. </param>
        internal ScheduledTrigger(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, TriggerKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, DateTimeOffset? createdOn, DataShareProvisioningState? provisioningState, DataShareSynchronizationRecurrenceInterval recurrenceInterval, SynchronizationMode? synchronizationMode, DateTimeOffset synchronizeOn, DataShareTriggerStatus? triggerStatus, string userName) : base(id, name, resourceType, systemData, kind, serializedAdditionalRawData)
        {
            CreatedOn = createdOn;
            ProvisioningState = provisioningState;
            RecurrenceInterval = recurrenceInterval;
            SynchronizationMode = synchronizationMode;
            SynchronizeOn = synchronizeOn;
            TriggerStatus = triggerStatus;
            UserName = userName;
            Kind = kind;
        }

        /// <summary> Initializes a new instance of <see cref="ScheduledTrigger"/> for deserialization. </summary>
        internal ScheduledTrigger()
        {
        }

        /// <summary> Time at which the trigger was created. </summary>
        public DateTimeOffset? CreatedOn { get; }
        /// <summary> Gets the provisioning state. </summary>
        public DataShareProvisioningState? ProvisioningState { get; }
        /// <summary> Recurrence Interval. </summary>
        public DataShareSynchronizationRecurrenceInterval RecurrenceInterval { get; set; }
        /// <summary> Synchronization mode. </summary>
        public SynchronizationMode? SynchronizationMode { get; set; }
        /// <summary> Synchronization time. </summary>
        public DateTimeOffset SynchronizeOn { get; set; }
        /// <summary> Gets the trigger state. </summary>
        public DataShareTriggerStatus? TriggerStatus { get; }
        /// <summary> Name of the user who created the trigger. </summary>
        public string UserName { get; }
    }
}
