// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.DataShare.Models
{
    /// <summary> A type of synchronization setting based on schedule. </summary>
    public partial class ScheduledSynchronizationSetting : DataShareSynchronizationSettingData
    {
        /// <summary> Initializes a new instance of <see cref="ScheduledSynchronizationSetting"/>. </summary>
        /// <param name="recurrenceInterval"> Recurrence Interval. </param>
        /// <param name="synchronizeOn"> Synchronization time. </param>
        public ScheduledSynchronizationSetting(DataShareSynchronizationRecurrenceInterval recurrenceInterval, DateTimeOffset synchronizeOn)
        {
            RecurrenceInterval = recurrenceInterval;
            SynchronizeOn = synchronizeOn;
            Kind = SynchronizationSettingKind.ScheduleBased;
        }

        /// <summary> Initializes a new instance of <see cref="ScheduledSynchronizationSetting"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="kind"> Kind of synchronization setting. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="createdOn"> Time at which the synchronization setting was created. </param>
        /// <param name="provisioningState"> Gets or sets the provisioning state. </param>
        /// <param name="recurrenceInterval"> Recurrence Interval. </param>
        /// <param name="synchronizeOn"> Synchronization time. </param>
        /// <param name="userName"> Name of the user who created the synchronization setting. </param>
        internal ScheduledSynchronizationSetting(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, SynchronizationSettingKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, DateTimeOffset? createdOn, DataShareProvisioningState? provisioningState, DataShareSynchronizationRecurrenceInterval recurrenceInterval, DateTimeOffset synchronizeOn, string userName) : base(id, name, resourceType, systemData, kind, serializedAdditionalRawData)
        {
            CreatedOn = createdOn;
            ProvisioningState = provisioningState;
            RecurrenceInterval = recurrenceInterval;
            SynchronizeOn = synchronizeOn;
            UserName = userName;
            Kind = kind;
        }

        /// <summary> Initializes a new instance of <see cref="ScheduledSynchronizationSetting"/> for deserialization. </summary>
        internal ScheduledSynchronizationSetting()
        {
        }

        /// <summary> Time at which the synchronization setting was created. </summary>
        public DateTimeOffset? CreatedOn { get; }
        /// <summary> Gets or sets the provisioning state. </summary>
        public DataShareProvisioningState? ProvisioningState { get; }
        /// <summary> Recurrence Interval. </summary>
        public DataShareSynchronizationRecurrenceInterval RecurrenceInterval { get; set; }
        /// <summary> Synchronization time. </summary>
        public DateTimeOffset SynchronizeOn { get; set; }
        /// <summary> Name of the user who created the synchronization setting. </summary>
        public string UserName { get; }
    }
}
