// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataShare.Models
{
    /// <summary> A type of synchronization setting based on schedule. </summary>
    public partial class ScheduledSourceSynchronizationSetting : SourceShareSynchronizationSetting
    {
        /// <summary> Initializes a new instance of <see cref="ScheduledSourceSynchronizationSetting"/>. </summary>
        internal ScheduledSourceSynchronizationSetting()
        {
            Kind = SourceShareSynchronizationSettingKind.ScheduleBased;
        }

        /// <summary> Initializes a new instance of <see cref="ScheduledSourceSynchronizationSetting"/>. </summary>
        /// <param name="kind"> Kind of synchronization setting on share. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="recurrenceInterval"> Recurrence Interval. </param>
        /// <param name="synchronizeOn"> Synchronization time. </param>
        internal ScheduledSourceSynchronizationSetting(SourceShareSynchronizationSettingKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, DataShareSynchronizationRecurrenceInterval? recurrenceInterval, DateTimeOffset? synchronizeOn) : base(kind, serializedAdditionalRawData)
        {
            RecurrenceInterval = recurrenceInterval;
            SynchronizeOn = synchronizeOn;
            Kind = kind;
        }

        /// <summary> Recurrence Interval. </summary>
        public DataShareSynchronizationRecurrenceInterval? RecurrenceInterval { get; }
        /// <summary> Synchronization time. </summary>
        public DateTimeOffset? SynchronizeOn { get; }
    }
}
