// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataShare.Models
{
    /// <summary> Gets the trigger state. </summary>
    public readonly partial struct DataShareTriggerStatus : IEquatable<DataShareTriggerStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataShareTriggerStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataShareTriggerStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActiveValue = "Active";
        private const string InactiveValue = "Inactive";
        private const string SourceSynchronizationSettingDeletedValue = "SourceSynchronizationSettingDeleted";

        /// <summary> Active. </summary>
        public static DataShareTriggerStatus Active { get; } = new DataShareTriggerStatus(ActiveValue);
        /// <summary> Inactive. </summary>
        public static DataShareTriggerStatus Inactive { get; } = new DataShareTriggerStatus(InactiveValue);
        /// <summary> SourceSynchronizationSettingDeleted. </summary>
        public static DataShareTriggerStatus SourceSynchronizationSettingDeleted { get; } = new DataShareTriggerStatus(SourceSynchronizationSettingDeletedValue);
        /// <summary> Determines if two <see cref="DataShareTriggerStatus"/> values are the same. </summary>
        public static bool operator ==(DataShareTriggerStatus left, DataShareTriggerStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataShareTriggerStatus"/> values are not the same. </summary>
        public static bool operator !=(DataShareTriggerStatus left, DataShareTriggerStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataShareTriggerStatus"/>. </summary>
        public static implicit operator DataShareTriggerStatus(string value) => new DataShareTriggerStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataShareTriggerStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataShareTriggerStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
