// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataShare.Models
{
    /// <summary> Type of output file. </summary>
    public readonly partial struct DataShareOutputType : IEquatable<DataShareOutputType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataShareOutputType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataShareOutputType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CsvValue = "Csv";
        private const string ParquetValue = "Parquet";

        /// <summary> Csv. </summary>
        public static DataShareOutputType Csv { get; } = new DataShareOutputType(CsvValue);
        /// <summary> Parquet. </summary>
        public static DataShareOutputType Parquet { get; } = new DataShareOutputType(ParquetValue);
        /// <summary> Determines if two <see cref="DataShareOutputType"/> values are the same. </summary>
        public static bool operator ==(DataShareOutputType left, DataShareOutputType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataShareOutputType"/> values are not the same. </summary>
        public static bool operator !=(DataShareOutputType left, DataShareOutputType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataShareOutputType"/>. </summary>
        public static implicit operator DataShareOutputType(string value) => new DataShareOutputType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataShareOutputType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataShareOutputType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
