// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataShare.Models
{
    /// <summary> Operation state of the long running operation. </summary>
    public readonly partial struct DataShareOperationStatus : IEquatable<DataShareOperationStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataShareOperationStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataShareOperationStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AcceptedValue = "Accepted";
        private const string InProgressValue = "InProgress";
        private const string TransientFailureValue = "TransientFailure";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";

        /// <summary> Accepted. </summary>
        public static DataShareOperationStatus Accepted { get; } = new DataShareOperationStatus(AcceptedValue);
        /// <summary> InProgress. </summary>
        public static DataShareOperationStatus InProgress { get; } = new DataShareOperationStatus(InProgressValue);
        /// <summary> TransientFailure. </summary>
        public static DataShareOperationStatus TransientFailure { get; } = new DataShareOperationStatus(TransientFailureValue);
        /// <summary> Succeeded. </summary>
        public static DataShareOperationStatus Succeeded { get; } = new DataShareOperationStatus(SucceededValue);
        /// <summary> Failed. </summary>
        public static DataShareOperationStatus Failed { get; } = new DataShareOperationStatus(FailedValue);
        /// <summary> Canceled. </summary>
        public static DataShareOperationStatus Canceled { get; } = new DataShareOperationStatus(CanceledValue);
        /// <summary> Determines if two <see cref="DataShareOperationStatus"/> values are the same. </summary>
        public static bool operator ==(DataShareOperationStatus left, DataShareOperationStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataShareOperationStatus"/> values are not the same. </summary>
        public static bool operator !=(DataShareOperationStatus left, DataShareOperationStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataShareOperationStatus"/>. </summary>
        public static implicit operator DataShareOperationStatus(string value) => new DataShareOperationStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataShareOperationStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataShareOperationStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
