// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataShare.Models
{
    /// <summary> Registration status. </summary>
    public readonly partial struct DataShareEmailRegistrationStatus : IEquatable<DataShareEmailRegistrationStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataShareEmailRegistrationStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataShareEmailRegistrationStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActivationPendingValue = "ActivationPending";
        private const string ActivatedValue = "Activated";
        private const string ActivationAttemptsExhaustedValue = "ActivationAttemptsExhausted";

        /// <summary> ActivationPending. </summary>
        public static DataShareEmailRegistrationStatus ActivationPending { get; } = new DataShareEmailRegistrationStatus(ActivationPendingValue);
        /// <summary> Activated. </summary>
        public static DataShareEmailRegistrationStatus Activated { get; } = new DataShareEmailRegistrationStatus(ActivatedValue);
        /// <summary> ActivationAttemptsExhausted. </summary>
        public static DataShareEmailRegistrationStatus ActivationAttemptsExhausted { get; } = new DataShareEmailRegistrationStatus(ActivationAttemptsExhaustedValue);
        /// <summary> Determines if two <see cref="DataShareEmailRegistrationStatus"/> values are the same. </summary>
        public static bool operator ==(DataShareEmailRegistrationStatus left, DataShareEmailRegistrationStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataShareEmailRegistrationStatus"/> values are not the same. </summary>
        public static bool operator !=(DataShareEmailRegistrationStatus left, DataShareEmailRegistrationStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataShareEmailRegistrationStatus"/>. </summary>
        public static implicit operator DataShareEmailRegistrationStatus(string value) => new DataShareEmailRegistrationStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataShareEmailRegistrationStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataShareEmailRegistrationStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
