// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataShare.Models
{
    /// <summary> Gets the status of the data set mapping. </summary>
    public readonly partial struct DataSetMappingStatus : IEquatable<DataSetMappingStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataSetMappingStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataSetMappingStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OkValue = "Ok";
        private const string BrokenValue = "Broken";

        /// <summary> Ok. </summary>
        public static DataSetMappingStatus Ok { get; } = new DataSetMappingStatus(OkValue);
        /// <summary> Broken. </summary>
        public static DataSetMappingStatus Broken { get; } = new DataSetMappingStatus(BrokenValue);
        /// <summary> Determines if two <see cref="DataSetMappingStatus"/> values are the same. </summary>
        public static bool operator ==(DataSetMappingStatus left, DataSetMappingStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataSetMappingStatus"/> values are not the same. </summary>
        public static bool operator !=(DataSetMappingStatus left, DataSetMappingStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataSetMappingStatus"/>. </summary>
        public static implicit operator DataSetMappingStatus(string value) => new DataSetMappingStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataSetMappingStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataSetMappingStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
