// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataShare.Models
{
    /// <summary> Kind of data set mapping. </summary>
    internal readonly partial struct DataSetMappingKind : IEquatable<DataSetMappingKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataSetMappingKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataSetMappingKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BlobValue = "Blob";
        private const string ContainerValue = "Container";
        private const string BlobFolderValue = "BlobFolder";
        private const string AdlsGen2FileSystemValue = "AdlsGen2FileSystem";
        private const string AdlsGen2FolderValue = "AdlsGen2Folder";
        private const string AdlsGen2FileValue = "AdlsGen2File";
        private const string KustoClusterValue = "KustoCluster";
        private const string KustoDatabaseValue = "KustoDatabase";
        private const string KustoTableValue = "KustoTable";
        private const string SqlDBTableValue = "SqlDBTable";
        private const string SqlDWTableValue = "SqlDWTable";
        private const string SynapseWorkspaceSqlPoolTableValue = "SynapseWorkspaceSqlPoolTable";

        /// <summary> Blob. </summary>
        public static DataSetMappingKind Blob { get; } = new DataSetMappingKind(BlobValue);
        /// <summary> Container. </summary>
        public static DataSetMappingKind Container { get; } = new DataSetMappingKind(ContainerValue);
        /// <summary> BlobFolder. </summary>
        public static DataSetMappingKind BlobFolder { get; } = new DataSetMappingKind(BlobFolderValue);
        /// <summary> AdlsGen2FileSystem. </summary>
        public static DataSetMappingKind AdlsGen2FileSystem { get; } = new DataSetMappingKind(AdlsGen2FileSystemValue);
        /// <summary> AdlsGen2Folder. </summary>
        public static DataSetMappingKind AdlsGen2Folder { get; } = new DataSetMappingKind(AdlsGen2FolderValue);
        /// <summary> AdlsGen2File. </summary>
        public static DataSetMappingKind AdlsGen2File { get; } = new DataSetMappingKind(AdlsGen2FileValue);
        /// <summary> KustoCluster. </summary>
        public static DataSetMappingKind KustoCluster { get; } = new DataSetMappingKind(KustoClusterValue);
        /// <summary> KustoDatabase. </summary>
        public static DataSetMappingKind KustoDatabase { get; } = new DataSetMappingKind(KustoDatabaseValue);
        /// <summary> KustoTable. </summary>
        public static DataSetMappingKind KustoTable { get; } = new DataSetMappingKind(KustoTableValue);
        /// <summary> SqlDBTable. </summary>
        public static DataSetMappingKind SqlDBTable { get; } = new DataSetMappingKind(SqlDBTableValue);
        /// <summary> SqlDWTable. </summary>
        public static DataSetMappingKind SqlDWTable { get; } = new DataSetMappingKind(SqlDWTableValue);
        /// <summary> SynapseWorkspaceSqlPoolTable. </summary>
        public static DataSetMappingKind SynapseWorkspaceSqlPoolTable { get; } = new DataSetMappingKind(SynapseWorkspaceSqlPoolTableValue);
        /// <summary> Determines if two <see cref="DataSetMappingKind"/> values are the same. </summary>
        public static bool operator ==(DataSetMappingKind left, DataSetMappingKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataSetMappingKind"/> values are not the same. </summary>
        public static bool operator !=(DataSetMappingKind left, DataSetMappingKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataSetMappingKind"/>. </summary>
        public static implicit operator DataSetMappingKind(string value) => new DataSetMappingKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataSetMappingKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataSetMappingKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
