// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataShare.Models
{
    /// <summary> Kind of data set. </summary>
    internal readonly partial struct DataSetKind : IEquatable<DataSetKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataSetKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataSetKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BlobValue = "Blob";
        private const string ContainerValue = "Container";
        private const string BlobFolderValue = "BlobFolder";
        private const string AdlsGen2FileSystemValue = "AdlsGen2FileSystem";
        private const string AdlsGen2FolderValue = "AdlsGen2Folder";
        private const string AdlsGen2FileValue = "AdlsGen2File";
        private const string AdlsGen1FolderValue = "AdlsGen1Folder";
        private const string AdlsGen1FileValue = "AdlsGen1File";
        private const string KustoClusterValue = "KustoCluster";
        private const string KustoDatabaseValue = "KustoDatabase";
        private const string KustoTableValue = "KustoTable";
        private const string SqlDBTableValue = "SqlDBTable";
        private const string SqlDWTableValue = "SqlDWTable";
        private const string SynapseWorkspaceSqlPoolTableValue = "SynapseWorkspaceSqlPoolTable";

        /// <summary> Blob. </summary>
        public static DataSetKind Blob { get; } = new DataSetKind(BlobValue);
        /// <summary> Container. </summary>
        public static DataSetKind Container { get; } = new DataSetKind(ContainerValue);
        /// <summary> BlobFolder. </summary>
        public static DataSetKind BlobFolder { get; } = new DataSetKind(BlobFolderValue);
        /// <summary> AdlsGen2FileSystem. </summary>
        public static DataSetKind AdlsGen2FileSystem { get; } = new DataSetKind(AdlsGen2FileSystemValue);
        /// <summary> AdlsGen2Folder. </summary>
        public static DataSetKind AdlsGen2Folder { get; } = new DataSetKind(AdlsGen2FolderValue);
        /// <summary> AdlsGen2File. </summary>
        public static DataSetKind AdlsGen2File { get; } = new DataSetKind(AdlsGen2FileValue);
        /// <summary> AdlsGen1Folder. </summary>
        public static DataSetKind AdlsGen1Folder { get; } = new DataSetKind(AdlsGen1FolderValue);
        /// <summary> AdlsGen1File. </summary>
        public static DataSetKind AdlsGen1File { get; } = new DataSetKind(AdlsGen1FileValue);
        /// <summary> KustoCluster. </summary>
        public static DataSetKind KustoCluster { get; } = new DataSetKind(KustoClusterValue);
        /// <summary> KustoDatabase. </summary>
        public static DataSetKind KustoDatabase { get; } = new DataSetKind(KustoDatabaseValue);
        /// <summary> KustoTable. </summary>
        public static DataSetKind KustoTable { get; } = new DataSetKind(KustoTableValue);
        /// <summary> SqlDBTable. </summary>
        public static DataSetKind SqlDBTable { get; } = new DataSetKind(SqlDBTableValue);
        /// <summary> SqlDWTable. </summary>
        public static DataSetKind SqlDWTable { get; } = new DataSetKind(SqlDWTableValue);
        /// <summary> SynapseWorkspaceSqlPoolTable. </summary>
        public static DataSetKind SynapseWorkspaceSqlPoolTable { get; } = new DataSetKind(SynapseWorkspaceSqlPoolTableValue);
        /// <summary> Determines if two <see cref="DataSetKind"/> values are the same. </summary>
        public static bool operator ==(DataSetKind left, DataSetKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataSetKind"/> values are not the same. </summary>
        public static bool operator !=(DataSetKind left, DataSetKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataSetKind"/>. </summary>
        public static implicit operator DataSetKind(string value) => new DataSetKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataSetKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataSetKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
