// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.DataShare.Models
{
    /// <summary> A consumer side dataSet data transfer object. </summary>
    public partial class ConsumerSourceDataSet : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ConsumerSourceDataSet"/>. </summary>
        public ConsumerSourceDataSet()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ConsumerSourceDataSet"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="dataSetId"> DataSet Id. </param>
        /// <param name="dataSetLocation"> Location of the data set. </param>
        /// <param name="dataSetName"> DataSet name. </param>
        /// <param name="dataSetPath"> DataSet path. </param>
        /// <param name="dataSetType"> Type of data set. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ConsumerSourceDataSet(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, Guid? dataSetId, AzureLocation? dataSetLocation, string dataSetName, string dataSetPath, ShareDataSetType? dataSetType, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            DataSetId = dataSetId;
            DataSetLocation = dataSetLocation;
            DataSetName = dataSetName;
            DataSetPath = dataSetPath;
            DataSetType = dataSetType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> DataSet Id. </summary>
        public Guid? DataSetId { get; }
        /// <summary> Location of the data set. </summary>
        public AzureLocation? DataSetLocation { get; }
        /// <summary> DataSet name. </summary>
        public string DataSetName { get; }
        /// <summary> DataSet path. </summary>
        public string DataSetPath { get; }
        /// <summary> Type of data set. </summary>
        public ShareDataSetType? DataSetType { get; }
    }
}
