// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.ResourceManager.DataShare.Models;

namespace Azure.ResourceManager.DataShare
{
    internal class ShareSubscriptionSynchronizationOperationSource : IOperationSource<ShareSubscriptionSynchronization>
    {
        ShareSubscriptionSynchronization IOperationSource<ShareSubscriptionSynchronization>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            return ShareSubscriptionSynchronization.DeserializeShareSubscriptionSynchronization(document.RootElement);
        }

        async ValueTask<ShareSubscriptionSynchronization> IOperationSource<ShareSubscriptionSynchronization>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            return ShareSubscriptionSynchronization.DeserializeShareSubscriptionSynchronization(document.RootElement);
        }
    }
}
