// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DataShare
{
    internal class ProviderShareSubscriptionOperationSource : IOperationSource<ProviderShareSubscriptionResource>
    {
        private readonly ArmClient _client;

        internal ProviderShareSubscriptionOperationSource(ArmClient client)
        {
            _client = client;
        }

        ProviderShareSubscriptionResource IOperationSource<ProviderShareSubscriptionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ProviderShareSubscriptionData.DeserializeProviderShareSubscriptionData(document.RootElement);
            return new ProviderShareSubscriptionResource(_client, data);
        }

        async ValueTask<ProviderShareSubscriptionResource> IOperationSource<ProviderShareSubscriptionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ProviderShareSubscriptionData.DeserializeProviderShareSubscriptionData(document.RootElement);
            return new ProviderShareSubscriptionResource(_client, data);
        }
    }
}
