// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DataShare
{
    internal class DataShareAccountOperationSource : IOperationSource<DataShareAccountResource>
    {
        private readonly ArmClient _client;

        internal DataShareAccountOperationSource(ArmClient client)
        {
            _client = client;
        }

        DataShareAccountResource IOperationSource<DataShareAccountResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DataShareAccountData.DeserializeDataShareAccountData(document.RootElement);
            return new DataShareAccountResource(_client, data);
        }

        async ValueTask<DataShareAccountResource> IOperationSource<DataShareAccountResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DataShareAccountData.DeserializeDataShareAccountData(document.RootElement);
            return new DataShareAccountResource(_client, data);
        }
    }
}
