// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.DataShare.Models;

namespace Azure.ResourceManager.DataShare.Mocking
{
    /// <summary> A class to add extension methods to TenantResource. </summary>
    public partial class MockableDataShareTenantResource : ArmResource
    {
        private ClientDiagnostics _dataShareConsumerInvitationConsumerInvitationsClientDiagnostics;
        private ConsumerInvitationsRestOperations _dataShareConsumerInvitationConsumerInvitationsRestClient;
        private ClientDiagnostics _emailRegistrationsClientDiagnostics;
        private EmailRegistrationsRestOperations _emailRegistrationsRestClient;

        /// <summary> Initializes a new instance of the <see cref="MockableDataShareTenantResource"/> class for mocking. </summary>
        protected MockableDataShareTenantResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableDataShareTenantResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableDataShareTenantResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private ClientDiagnostics DataShareConsumerInvitationConsumerInvitationsClientDiagnostics => _dataShareConsumerInvitationConsumerInvitationsClientDiagnostics ??= new ClientDiagnostics("Azure.ResourceManager.DataShare", DataShareConsumerInvitationResource.ResourceType.Namespace, Diagnostics);
        private ConsumerInvitationsRestOperations DataShareConsumerInvitationConsumerInvitationsRestClient => _dataShareConsumerInvitationConsumerInvitationsRestClient ??= new ConsumerInvitationsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, GetApiVersionOrNull(DataShareConsumerInvitationResource.ResourceType));
        private ClientDiagnostics EmailRegistrationsClientDiagnostics => _emailRegistrationsClientDiagnostics ??= new ClientDiagnostics("Azure.ResourceManager.DataShare", ProviderConstants.DefaultProviderNamespace, Diagnostics);
        private EmailRegistrationsRestOperations EmailRegistrationsRestClient => _emailRegistrationsRestClient ??= new EmailRegistrationsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary> Gets a collection of DataShareConsumerInvitationResources in the TenantResource. </summary>
        /// <returns> An object representing collection of DataShareConsumerInvitationResources and their operations over a DataShareConsumerInvitationResource. </returns>
        public virtual DataShareConsumerInvitationCollection GetDataShareConsumerInvitations()
        {
            return GetCachedClient(client => new DataShareConsumerInvitationCollection(client, Id));
        }

        /// <summary>
        /// Get an invitation
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.DataShare/locations/{location}/consumerInvitations/{invitationId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConsumerInvitations_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataShareConsumerInvitationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="location"> Location of the invitation. </param>
        /// <param name="invitationId"> An invitation id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        [ForwardsClientCalls]
        public virtual async Task<Response<DataShareConsumerInvitationResource>> GetDataShareConsumerInvitationAsync(AzureLocation location, Guid invitationId, CancellationToken cancellationToken = default)
        {
            return await GetDataShareConsumerInvitations().GetAsync(location, invitationId, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get an invitation
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.DataShare/locations/{location}/consumerInvitations/{invitationId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConsumerInvitations_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataShareConsumerInvitationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="location"> Location of the invitation. </param>
        /// <param name="invitationId"> An invitation id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        [ForwardsClientCalls]
        public virtual Response<DataShareConsumerInvitationResource> GetDataShareConsumerInvitation(AzureLocation location, Guid invitationId, CancellationToken cancellationToken = default)
        {
            return GetDataShareConsumerInvitations().Get(location, invitationId, cancellationToken);
        }

        /// <summary>
        /// Reject an invitation
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.DataShare/locations/{location}/rejectInvitation</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConsumerInvitations_RejectInvitation</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataShareConsumerInvitationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="location"> Location of the invitation. </param>
        /// <param name="data"> An invitation payload. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual async Task<Response<DataShareConsumerInvitationResource>> RejectConsumerInvitationAsync(AzureLocation location, DataShareConsumerInvitationData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = DataShareConsumerInvitationConsumerInvitationsClientDiagnostics.CreateScope("MockableDataShareTenantResource.RejectConsumerInvitation");
            scope.Start();
            try
            {
                var response = await DataShareConsumerInvitationConsumerInvitationsRestClient.RejectInvitationAsync(location, data, cancellationToken).ConfigureAwait(false);
                return Response.FromValue(new DataShareConsumerInvitationResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Reject an invitation
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.DataShare/locations/{location}/rejectInvitation</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConsumerInvitations_RejectInvitation</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataShareConsumerInvitationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="location"> Location of the invitation. </param>
        /// <param name="data"> An invitation payload. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual Response<DataShareConsumerInvitationResource> RejectConsumerInvitation(AzureLocation location, DataShareConsumerInvitationData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = DataShareConsumerInvitationConsumerInvitationsClientDiagnostics.CreateScope("MockableDataShareTenantResource.RejectConsumerInvitation");
            scope.Start();
            try
            {
                var response = DataShareConsumerInvitationConsumerInvitationsRestClient.RejectInvitation(location, data, cancellationToken);
                return Response.FromValue(new DataShareConsumerInvitationResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Activate the email registration for the current tenant
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.DataShare/locations/{location}/activateEmail</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EmailRegistrations_ActivateEmail</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-08-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="location"> Location of the activation. </param>
        /// <param name="emailRegistration"> The payload for tenant domain activation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="emailRegistration"/> is null. </exception>
        public virtual async Task<Response<DataShareEmailRegistration>> ActivateEmailAsync(AzureLocation location, DataShareEmailRegistration emailRegistration, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(emailRegistration, nameof(emailRegistration));

            using var scope = EmailRegistrationsClientDiagnostics.CreateScope("MockableDataShareTenantResource.ActivateEmail");
            scope.Start();
            try
            {
                var response = await EmailRegistrationsRestClient.ActivateEmailAsync(location, emailRegistration, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Activate the email registration for the current tenant
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.DataShare/locations/{location}/activateEmail</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EmailRegistrations_ActivateEmail</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-08-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="location"> Location of the activation. </param>
        /// <param name="emailRegistration"> The payload for tenant domain activation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="emailRegistration"/> is null. </exception>
        public virtual Response<DataShareEmailRegistration> ActivateEmail(AzureLocation location, DataShareEmailRegistration emailRegistration, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(emailRegistration, nameof(emailRegistration));

            using var scope = EmailRegistrationsClientDiagnostics.CreateScope("MockableDataShareTenantResource.ActivateEmail");
            scope.Start();
            try
            {
                var response = EmailRegistrationsRestClient.ActivateEmail(location, emailRegistration, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Register an email for the current tenant
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.DataShare/locations/{location}/registerEmail</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EmailRegistrations_RegisterEmail</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-08-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="location"> Location of the registration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<DataShareEmailRegistration>> RegisterEmailAsync(AzureLocation location, CancellationToken cancellationToken = default)
        {
            using var scope = EmailRegistrationsClientDiagnostics.CreateScope("MockableDataShareTenantResource.RegisterEmail");
            scope.Start();
            try
            {
                var response = await EmailRegistrationsRestClient.RegisterEmailAsync(location, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Register an email for the current tenant
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.DataShare/locations/{location}/registerEmail</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EmailRegistrations_RegisterEmail</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-08-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="location"> Location of the registration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<DataShareEmailRegistration> RegisterEmail(AzureLocation location, CancellationToken cancellationToken = default)
        {
            using var scope = EmailRegistrationsClientDiagnostics.CreateScope("MockableDataShareTenantResource.RegisterEmail");
            scope.Start();
            try
            {
                var response = EmailRegistrationsRestClient.RegisterEmail(location, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
