// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.DataShare.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.DataShare
{
    /// <summary>
    /// A class representing the DataShareInvitation data model.
    /// A Invitation data transfer object.
    /// </summary>
    public partial class DataShareInvitationData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataShareInvitationData"/>. </summary>
        public DataShareInvitationData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DataShareInvitationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="expireOn"> The expiration date for the invitation and share subscription. </param>
        /// <param name="invitationId"> unique invitation id. </param>
        /// <param name="invitationStatus"> The status of the invitation. </param>
        /// <param name="respondedOn"> The time the recipient responded to the invitation. </param>
        /// <param name="sentOn"> Gets the time at which the invitation was sent. </param>
        /// <param name="targetActiveDirectoryId"> The target Azure AD Id. Can't be combined with email. </param>
        /// <param name="targetEmail"> The email the invitation is directed to. </param>
        /// <param name="targetObjectId">
        /// The target user or application Id that invitation is being sent to.
        /// Must be specified along TargetActiveDirectoryId. This enables sending
        /// invitations to specific users or applications in an AD tenant.
        /// </param>
        /// <param name="userEmail"> Email of the user who created the resource. </param>
        /// <param name="userName"> Name of the user who created the resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataShareInvitationData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, DateTimeOffset? expireOn, Guid? invitationId, DataShareInvitationStatus? invitationStatus, DateTimeOffset? respondedOn, DateTimeOffset? sentOn, string targetActiveDirectoryId, string targetEmail, string targetObjectId, string userEmail, string userName, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            ExpireOn = expireOn;
            InvitationId = invitationId;
            InvitationStatus = invitationStatus;
            RespondedOn = respondedOn;
            SentOn = sentOn;
            TargetActiveDirectoryId = targetActiveDirectoryId;
            TargetEmail = targetEmail;
            TargetObjectId = targetObjectId;
            UserEmail = userEmail;
            UserName = userName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The expiration date for the invitation and share subscription. </summary>
        public DateTimeOffset? ExpireOn { get; set; }
        /// <summary> unique invitation id. </summary>
        public Guid? InvitationId { get; }
        /// <summary> The status of the invitation. </summary>
        public DataShareInvitationStatus? InvitationStatus { get; }
        /// <summary> The time the recipient responded to the invitation. </summary>
        public DateTimeOffset? RespondedOn { get; }
        /// <summary> Gets the time at which the invitation was sent. </summary>
        public DateTimeOffset? SentOn { get; }
        /// <summary> The target Azure AD Id. Can't be combined with email. </summary>
        public string TargetActiveDirectoryId { get; set; }
        /// <summary> The email the invitation is directed to. </summary>
        public string TargetEmail { get; set; }
        /// <summary>
        /// The target user or application Id that invitation is being sent to.
        /// Must be specified along TargetActiveDirectoryId. This enables sending
        /// invitations to specific users or applications in an AD tenant.
        /// </summary>
        public string TargetObjectId { get; set; }
        /// <summary> Email of the user who created the resource. </summary>
        public string UserEmail { get; }
        /// <summary> Name of the user who created the resource. </summary>
        public string UserName { get; }
    }
}
