// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.DataShare.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.DataShare
{
    public partial class DataShareInvitationData : IUtf8JsonSerializable, IJsonModel<DataShareInvitationData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<DataShareInvitationData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<DataShareInvitationData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataShareInvitationData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DataShareInvitationData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(ExpireOn))
            {
                writer.WritePropertyName("expirationDate"u8);
                writer.WriteStringValue(ExpireOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(InvitationId))
            {
                writer.WritePropertyName("invitationId"u8);
                writer.WriteStringValue(InvitationId.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(InvitationStatus))
            {
                writer.WritePropertyName("invitationStatus"u8);
                writer.WriteStringValue(InvitationStatus.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(RespondedOn))
            {
                writer.WritePropertyName("respondedAt"u8);
                writer.WriteStringValue(RespondedOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(SentOn))
            {
                writer.WritePropertyName("sentAt"u8);
                writer.WriteStringValue(SentOn.Value, "O");
            }
            if (Optional.IsDefined(TargetActiveDirectoryId))
            {
                writer.WritePropertyName("targetActiveDirectoryId"u8);
                writer.WriteStringValue(TargetActiveDirectoryId);
            }
            if (Optional.IsDefined(TargetEmail))
            {
                writer.WritePropertyName("targetEmail"u8);
                writer.WriteStringValue(TargetEmail);
            }
            if (Optional.IsDefined(TargetObjectId))
            {
                writer.WritePropertyName("targetObjectId"u8);
                writer.WriteStringValue(TargetObjectId);
            }
            if (options.Format != "W" && Optional.IsDefined(UserEmail))
            {
                writer.WritePropertyName("userEmail"u8);
                writer.WriteStringValue(UserEmail);
            }
            if (options.Format != "W" && Optional.IsDefined(UserName))
            {
                writer.WritePropertyName("userName"u8);
                writer.WriteStringValue(UserName);
            }
            writer.WriteEndObject();
        }

        DataShareInvitationData IJsonModel<DataShareInvitationData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataShareInvitationData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DataShareInvitationData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeDataShareInvitationData(document.RootElement, options);
        }

        internal static DataShareInvitationData DeserializeDataShareInvitationData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            DateTimeOffset? expirationDate = default;
            Guid? invitationId = default;
            DataShareInvitationStatus? invitationStatus = default;
            DateTimeOffset? respondedAt = default;
            DateTimeOffset? sentAt = default;
            string targetActiveDirectoryId = default;
            string targetEmail = default;
            string targetObjectId = default;
            string userEmail = default;
            string userName = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("expirationDate"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            expirationDate = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("invitationId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            invitationId = property0.Value.GetGuid();
                            continue;
                        }
                        if (property0.NameEquals("invitationStatus"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            invitationStatus = new DataShareInvitationStatus(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("respondedAt"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            respondedAt = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("sentAt"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            sentAt = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("targetActiveDirectoryId"u8))
                        {
                            targetActiveDirectoryId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("targetEmail"u8))
                        {
                            targetEmail = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("targetObjectId"u8))
                        {
                            targetObjectId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("userEmail"u8))
                        {
                            userEmail = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("userName"u8))
                        {
                            userName = property0.Value.GetString();
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new DataShareInvitationData(
                id,
                name,
                type,
                systemData,
                expirationDate,
                invitationId,
                invitationStatus,
                respondedAt,
                sentAt,
                targetActiveDirectoryId,
                targetEmail,
                targetObjectId,
                userEmail,
                userName,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<DataShareInvitationData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataShareInvitationData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(DataShareInvitationData)} does not support writing '{options.Format}' format.");
            }
        }

        DataShareInvitationData IPersistableModel<DataShareInvitationData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataShareInvitationData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeDataShareInvitationData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(DataShareInvitationData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<DataShareInvitationData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
