// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.DataShare.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.DataShare
{
    /// <summary>
    /// A class representing the DataShareConsumerInvitation data model.
    /// A consumer Invitation data transfer object.
    /// </summary>
    public partial class DataShareConsumerInvitationData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataShareConsumerInvitationData"/>. </summary>
        /// <param name="invitationId"> Unique id of the invitation. </param>
        public DataShareConsumerInvitationData(Guid invitationId)
        {
            InvitationId = invitationId;
        }

        /// <summary> Initializes a new instance of <see cref="DataShareConsumerInvitationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="dataSetCount"> Number of data sets in a share. </param>
        /// <param name="description"> Description shared when the invitation was created. </param>
        /// <param name="expireOn"> The expiration date for the share subscription created by accepting the invitation. </param>
        /// <param name="invitationId"> Unique id of the invitation. </param>
        /// <param name="invitationStatus"> The status of the invitation. </param>
        /// <param name="location"> invitation location. </param>
        /// <param name="providerEmail"> Email of the provider who created the resource. </param>
        /// <param name="providerName"> Name of the provider who created the resource. </param>
        /// <param name="providerTenantName"> Tenant name of the provider who created the resource. </param>
        /// <param name="respondedOn"> The time the recipient responded to the invitation. </param>
        /// <param name="sentOn"> Gets the time at which the invitation was sent. </param>
        /// <param name="shareName"> Gets the source share Name. </param>
        /// <param name="termsOfUse"> Terms of use shared when the invitation was created. </param>
        /// <param name="userEmail"> Email of the user who created the resource. </param>
        /// <param name="userName"> Name of the user who created the resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataShareConsumerInvitationData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, int? dataSetCount, string description, DateTimeOffset? expireOn, Guid invitationId, DataShareInvitationStatus? invitationStatus, AzureLocation? location, string providerEmail, string providerName, string providerTenantName, DateTimeOffset? respondedOn, DateTimeOffset? sentOn, string shareName, string termsOfUse, string userEmail, string userName, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            DataSetCount = dataSetCount;
            Description = description;
            ExpireOn = expireOn;
            InvitationId = invitationId;
            InvitationStatus = invitationStatus;
            Location = location;
            ProviderEmail = providerEmail;
            ProviderName = providerName;
            ProviderTenantName = providerTenantName;
            RespondedOn = respondedOn;
            SentOn = sentOn;
            ShareName = shareName;
            TermsOfUse = termsOfUse;
            UserEmail = userEmail;
            UserName = userName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DataShareConsumerInvitationData"/> for deserialization. </summary>
        internal DataShareConsumerInvitationData()
        {
        }

        /// <summary> Number of data sets in a share. </summary>
        public int? DataSetCount { get; }
        /// <summary> Description shared when the invitation was created. </summary>
        public string Description { get; }
        /// <summary> The expiration date for the share subscription created by accepting the invitation. </summary>
        public DateTimeOffset? ExpireOn { get; }
        /// <summary> Unique id of the invitation. </summary>
        public Guid InvitationId { get; set; }
        /// <summary> The status of the invitation. </summary>
        public DataShareInvitationStatus? InvitationStatus { get; }
        /// <summary> invitation location. </summary>
        public AzureLocation? Location { get; }
        /// <summary> Email of the provider who created the resource. </summary>
        public string ProviderEmail { get; }
        /// <summary> Name of the provider who created the resource. </summary>
        public string ProviderName { get; }
        /// <summary> Tenant name of the provider who created the resource. </summary>
        public string ProviderTenantName { get; }
        /// <summary> The time the recipient responded to the invitation. </summary>
        public DateTimeOffset? RespondedOn { get; }
        /// <summary> Gets the time at which the invitation was sent. </summary>
        public DateTimeOffset? SentOn { get; }
        /// <summary> Gets the source share Name. </summary>
        public string ShareName { get; }
        /// <summary> Terms of use shared when the invitation was created. </summary>
        public string TermsOfUse { get; }
        /// <summary> Email of the user who created the resource. </summary>
        public string UserEmail { get; }
        /// <summary> Name of the user who created the resource. </summary>
        public string UserName { get; }
    }
}
