// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.DataShare.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.DataShare
{
    public partial class DataShareConsumerInvitationData : IUtf8JsonSerializable, IJsonModel<DataShareConsumerInvitationData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<DataShareConsumerInvitationData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<DataShareConsumerInvitationData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataShareConsumerInvitationData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DataShareConsumerInvitationData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (options.Format != "W" && Optional.IsDefined(DataSetCount))
            {
                writer.WritePropertyName("dataSetCount"u8);
                writer.WriteNumberValue(DataSetCount.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(Description))
            {
                writer.WritePropertyName("description"u8);
                writer.WriteStringValue(Description);
            }
            if (options.Format != "W" && Optional.IsDefined(ExpireOn))
            {
                writer.WritePropertyName("expirationDate"u8);
                writer.WriteStringValue(ExpireOn.Value, "O");
            }
            writer.WritePropertyName("invitationId"u8);
            writer.WriteStringValue(InvitationId);
            if (options.Format != "W" && Optional.IsDefined(InvitationStatus))
            {
                writer.WritePropertyName("invitationStatus"u8);
                writer.WriteStringValue(InvitationStatus.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(Location))
            {
                writer.WritePropertyName("location"u8);
                writer.WriteStringValue(Location.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ProviderEmail))
            {
                writer.WritePropertyName("providerEmail"u8);
                writer.WriteStringValue(ProviderEmail);
            }
            if (options.Format != "W" && Optional.IsDefined(ProviderName))
            {
                writer.WritePropertyName("providerName"u8);
                writer.WriteStringValue(ProviderName);
            }
            if (options.Format != "W" && Optional.IsDefined(ProviderTenantName))
            {
                writer.WritePropertyName("providerTenantName"u8);
                writer.WriteStringValue(ProviderTenantName);
            }
            if (options.Format != "W" && Optional.IsDefined(RespondedOn))
            {
                writer.WritePropertyName("respondedAt"u8);
                writer.WriteStringValue(RespondedOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(SentOn))
            {
                writer.WritePropertyName("sentAt"u8);
                writer.WriteStringValue(SentOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(ShareName))
            {
                writer.WritePropertyName("shareName"u8);
                writer.WriteStringValue(ShareName);
            }
            if (options.Format != "W" && Optional.IsDefined(TermsOfUse))
            {
                writer.WritePropertyName("termsOfUse"u8);
                writer.WriteStringValue(TermsOfUse);
            }
            if (options.Format != "W" && Optional.IsDefined(UserEmail))
            {
                writer.WritePropertyName("userEmail"u8);
                writer.WriteStringValue(UserEmail);
            }
            if (options.Format != "W" && Optional.IsDefined(UserName))
            {
                writer.WritePropertyName("userName"u8);
                writer.WriteStringValue(UserName);
            }
            writer.WriteEndObject();
        }

        DataShareConsumerInvitationData IJsonModel<DataShareConsumerInvitationData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataShareConsumerInvitationData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DataShareConsumerInvitationData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeDataShareConsumerInvitationData(document.RootElement, options);
        }

        internal static DataShareConsumerInvitationData DeserializeDataShareConsumerInvitationData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            int? dataSetCount = default;
            string description = default;
            DateTimeOffset? expirationDate = default;
            Guid invitationId = default;
            DataShareInvitationStatus? invitationStatus = default;
            AzureLocation? location = default;
            string providerEmail = default;
            string providerName = default;
            string providerTenantName = default;
            DateTimeOffset? respondedAt = default;
            DateTimeOffset? sentAt = default;
            string shareName = default;
            string termsOfUse = default;
            string userEmail = default;
            string userName = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("dataSetCount"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            dataSetCount = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("description"u8))
                        {
                            description = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("expirationDate"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            expirationDate = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("invitationId"u8))
                        {
                            invitationId = property0.Value.GetGuid();
                            continue;
                        }
                        if (property0.NameEquals("invitationStatus"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            invitationStatus = new DataShareInvitationStatus(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("location"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            location = new AzureLocation(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("providerEmail"u8))
                        {
                            providerEmail = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("providerName"u8))
                        {
                            providerName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("providerTenantName"u8))
                        {
                            providerTenantName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("respondedAt"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            respondedAt = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("sentAt"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            sentAt = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("shareName"u8))
                        {
                            shareName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("termsOfUse"u8))
                        {
                            termsOfUse = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("userEmail"u8))
                        {
                            userEmail = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("userName"u8))
                        {
                            userName = property0.Value.GetString();
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new DataShareConsumerInvitationData(
                id,
                name,
                type,
                systemData,
                dataSetCount,
                description,
                expirationDate,
                invitationId,
                invitationStatus,
                location,
                providerEmail,
                providerName,
                providerTenantName,
                respondedAt,
                sentAt,
                shareName,
                termsOfUse,
                userEmail,
                userName,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<DataShareConsumerInvitationData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataShareConsumerInvitationData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(DataShareConsumerInvitationData)} does not support writing '{options.Format}' format.");
            }
        }

        DataShareConsumerInvitationData IPersistableModel<DataShareConsumerInvitationData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataShareConsumerInvitationData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeDataShareConsumerInvitationData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(DataShareConsumerInvitationData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<DataShareConsumerInvitationData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
