// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.DataShare.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmDataShareModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="DataShare.DataShareAccountData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="identity"> Identity Info on the Account. Current supported identity types: SystemAssigned. </param>
        /// <param name="createdOn"> Time at which the account was created. </param>
        /// <param name="provisioningState"> Provisioning state of the Account. </param>
        /// <param name="userEmail"> Email of the user who created the resource. </param>
        /// <param name="userName"> Name of the user who created the resource. </param>
        /// <returns> A new <see cref="DataShare.DataShareAccountData"/> instance for mocking. </returns>
        public static DataShareAccountData DataShareAccountData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ManagedServiceIdentity identity = null, DateTimeOffset? createdOn = null, DataShareProvisioningState? provisioningState = null, string userEmail = null, string userName = null)
        {
            tags ??= new Dictionary<string, string>();

            return new DataShareAccountData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                identity,
                createdOn,
                provisioningState,
                userEmail,
                userName,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataShareOperationResult"/>. </summary>
        /// <param name="endOn"> start time. </param>
        /// <param name="error"> The error property when status is failed. </param>
        /// <param name="startOn"> start time. </param>
        /// <param name="status"> Operation state of the long running operation. </param>
        /// <returns> A new <see cref="Models.DataShareOperationResult"/> instance for mocking. </returns>
        public static DataShareOperationResult DataShareOperationResult(DateTimeOffset? endOn = null, ResponseError error = null, DateTimeOffset? startOn = null, DataShareOperationStatus status = default)
        {
            return new DataShareOperationResult(endOn, error, startOn, status, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DataShare.DataShareConsumerInvitationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="dataSetCount"> Number of data sets in a share. </param>
        /// <param name="description"> Description shared when the invitation was created. </param>
        /// <param name="expireOn"> The expiration date for the share subscription created by accepting the invitation. </param>
        /// <param name="invitationId"> Unique id of the invitation. </param>
        /// <param name="invitationStatus"> The status of the invitation. </param>
        /// <param name="location"> invitation location. </param>
        /// <param name="providerEmail"> Email of the provider who created the resource. </param>
        /// <param name="providerName"> Name of the provider who created the resource. </param>
        /// <param name="providerTenantName"> Tenant name of the provider who created the resource. </param>
        /// <param name="respondedOn"> The time the recipient responded to the invitation. </param>
        /// <param name="sentOn"> Gets the time at which the invitation was sent. </param>
        /// <param name="shareName"> Gets the source share Name. </param>
        /// <param name="termsOfUse"> Terms of use shared when the invitation was created. </param>
        /// <param name="userEmail"> Email of the user who created the resource. </param>
        /// <param name="userName"> Name of the user who created the resource. </param>
        /// <returns> A new <see cref="DataShare.DataShareConsumerInvitationData"/> instance for mocking. </returns>
        public static DataShareConsumerInvitationData DataShareConsumerInvitationData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, int? dataSetCount = null, string description = null, DateTimeOffset? expireOn = null, Guid invitationId = default, DataShareInvitationStatus? invitationStatus = null, AzureLocation? location = null, string providerEmail = null, string providerName = null, string providerTenantName = null, DateTimeOffset? respondedOn = null, DateTimeOffset? sentOn = null, string shareName = null, string termsOfUse = null, string userEmail = null, string userName = null)
        {
            return new DataShareConsumerInvitationData(
                id,
                name,
                resourceType,
                systemData,
                dataSetCount,
                description,
                expireOn,
                invitationId,
                invitationStatus,
                location,
                providerEmail,
                providerName,
                providerTenantName,
                respondedOn,
                sentOn,
                shareName,
                termsOfUse,
                userEmail,
                userName,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DataShare.ShareDataSetData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="kind"> Kind of data set. </param>
        /// <returns> A new <see cref="DataShare.ShareDataSetData"/> instance for mocking. </returns>
        public static ShareDataSetData ShareDataSetData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string kind = null)
        {
            return new ShareDataSetData(
                id,
                name,
                resourceType,
                systemData,
                kind == null ? default : new DataSetKind(kind),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DataShare.ShareDataSetMappingData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="kind"> Kind of data set mapping. </param>
        /// <returns> A new <see cref="DataShare.ShareDataSetMappingData"/> instance for mocking. </returns>
        public static ShareDataSetMappingData ShareDataSetMappingData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string kind = null)
        {
            return new ShareDataSetMappingData(
                id,
                name,
                resourceType,
                systemData,
                kind == null ? default : new DataSetMappingKind(kind),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataShareEmailRegistration"/>. </summary>
        /// <param name="activationCode"> Activation code for the registration. </param>
        /// <param name="activationExpireOn"> Date of the activation expiration. </param>
        /// <param name="email"> The email to register. </param>
        /// <param name="registrationStatus"> Registration status. </param>
        /// <param name="tenantId"> The tenant to register. </param>
        /// <returns> A new <see cref="Models.DataShareEmailRegistration"/> instance for mocking. </returns>
        public static DataShareEmailRegistration DataShareEmailRegistration(string activationCode = null, DateTimeOffset? activationExpireOn = null, string email = null, DataShareEmailRegistrationStatus? registrationStatus = null, Guid? tenantId = null)
        {
            return new DataShareEmailRegistration(
                activationCode,
                activationExpireOn,
                email,
                registrationStatus,
                tenantId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DataShare.DataShareInvitationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="expireOn"> The expiration date for the invitation and share subscription. </param>
        /// <param name="invitationId"> unique invitation id. </param>
        /// <param name="invitationStatus"> The status of the invitation. </param>
        /// <param name="respondedOn"> The time the recipient responded to the invitation. </param>
        /// <param name="sentOn"> Gets the time at which the invitation was sent. </param>
        /// <param name="targetActiveDirectoryId"> The target Azure AD Id. Can't be combined with email. </param>
        /// <param name="targetEmail"> The email the invitation is directed to. </param>
        /// <param name="targetObjectId">
        /// The target user or application Id that invitation is being sent to.
        /// Must be specified along TargetActiveDirectoryId. This enables sending
        /// invitations to specific users or applications in an AD tenant.
        /// </param>
        /// <param name="userEmail"> Email of the user who created the resource. </param>
        /// <param name="userName"> Name of the user who created the resource. </param>
        /// <returns> A new <see cref="DataShare.DataShareInvitationData"/> instance for mocking. </returns>
        public static DataShareInvitationData DataShareInvitationData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DateTimeOffset? expireOn = null, Guid? invitationId = null, DataShareInvitationStatus? invitationStatus = null, DateTimeOffset? respondedOn = null, DateTimeOffset? sentOn = null, string targetActiveDirectoryId = null, string targetEmail = null, string targetObjectId = null, string userEmail = null, string userName = null)
        {
            return new DataShareInvitationData(
                id,
                name,
                resourceType,
                systemData,
                expireOn,
                invitationId,
                invitationStatus,
                respondedOn,
                sentOn,
                targetActiveDirectoryId,
                targetEmail,
                targetObjectId,
                userEmail,
                userName,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ShareSynchronization"/>. </summary>
        /// <param name="consumerEmail"> Email of the user who created the synchronization. </param>
        /// <param name="consumerName"> Name of the user who created the synchronization. </param>
        /// <param name="consumerTenantName"> Tenant name of the consumer who created the synchronization. </param>
        /// <param name="durationInMilliSeconds"> synchronization duration. </param>
        /// <param name="endOn"> End time of synchronization. </param>
        /// <param name="message"> message of synchronization. </param>
        /// <param name="startOn"> start time of synchronization. </param>
        /// <param name="status"> Raw Status. </param>
        /// <param name="synchronizationId"> Synchronization id. </param>
        /// <param name="synchronizationMode"> Synchronization mode. </param>
        /// <returns> A new <see cref="Models.ShareSynchronization"/> instance for mocking. </returns>
        public static ShareSynchronization ShareSynchronization(string consumerEmail = null, string consumerName = null, string consumerTenantName = null, int? durationInMilliSeconds = null, DateTimeOffset? endOn = null, string message = null, DateTimeOffset? startOn = null, string status = null, Guid? synchronizationId = null, SynchronizationMode? synchronizationMode = null)
        {
            return new ShareSynchronization(
                consumerEmail,
                consumerName,
                consumerTenantName,
                durationInMilliSeconds,
                endOn,
                message,
                startOn,
                status,
                synchronizationId,
                synchronizationMode,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynchronizationDetails"/>. </summary>
        /// <param name="dataSetId"> Id of data set. </param>
        /// <param name="dataSetType"> Type of the data set. </param>
        /// <param name="durationInMilliSeconds"> Duration of data set level copy. </param>
        /// <param name="endOn"> End time of data set level copy. </param>
        /// <param name="filesRead"> The number of files read from the source data set. </param>
        /// <param name="filesWritten"> The number of files written into the sink data set. </param>
        /// <param name="message"> Error message if any. </param>
        /// <param name="name"> Name of the data set. </param>
        /// <param name="rowsCopied"> The number of files copied into the sink data set. </param>
        /// <param name="rowsRead"> The number of rows read from the source data set. </param>
        /// <param name="sizeRead"> The size of the data read from the source data set in bytes. </param>
        /// <param name="sizeWritten"> The size of the data written into the sink data set in bytes. </param>
        /// <param name="startOn"> Start time of data set level copy. </param>
        /// <param name="status"> Raw Status. </param>
        /// <param name="vCore"> The vCore units consumed for the data set synchronization. </param>
        /// <returns> A new <see cref="Models.SynchronizationDetails"/> instance for mocking. </returns>
        public static SynchronizationDetails SynchronizationDetails(Guid? dataSetId = null, ShareDataSetType? dataSetType = null, int? durationInMilliSeconds = null, DateTimeOffset? endOn = null, long? filesRead = null, long? filesWritten = null, string message = null, string name = null, long? rowsCopied = null, long? rowsRead = null, long? sizeRead = null, long? sizeWritten = null, DateTimeOffset? startOn = null, string status = null, long? vCore = null)
        {
            return new SynchronizationDetails(
                dataSetId,
                dataSetType,
                durationInMilliSeconds,
                endOn,
                filesRead,
                filesWritten,
                message,
                name,
                rowsCopied,
                rowsRead,
                sizeRead,
                sizeWritten,
                startOn,
                status,
                vCore,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DataShare.ProviderShareSubscriptionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="consumerEmail"> Email of the consumer who created the share subscription. </param>
        /// <param name="consumerName"> Name of the consumer who created the share subscription. </param>
        /// <param name="consumerTenantName"> Tenant name of the consumer who created the share subscription. </param>
        /// <param name="createdOn"> created at. </param>
        /// <param name="expireOn"> Expiration date of the share subscription in UTC format. </param>
        /// <param name="providerEmail"> Email of the provider who created the share. </param>
        /// <param name="providerName"> Name of the provider who created the share. </param>
        /// <param name="sharedOn"> Shared at. </param>
        /// <param name="shareSubscriptionObjectId"> share Subscription Object Id. </param>
        /// <param name="shareSubscriptionStatus"> Gets the status of share subscription. </param>
        /// <returns> A new <see cref="DataShare.ProviderShareSubscriptionData"/> instance for mocking. </returns>
        public static ProviderShareSubscriptionData ProviderShareSubscriptionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string consumerEmail = null, string consumerName = null, string consumerTenantName = null, DateTimeOffset? createdOn = null, DateTimeOffset? expireOn = null, string providerEmail = null, string providerName = null, DateTimeOffset? sharedOn = null, string shareSubscriptionObjectId = null, ShareSubscriptionStatus? shareSubscriptionStatus = null)
        {
            return new ProviderShareSubscriptionData(
                id,
                name,
                resourceType,
                systemData,
                consumerEmail,
                consumerName,
                consumerTenantName,
                createdOn,
                expireOn,
                providerEmail,
                providerName,
                sharedOn,
                shareSubscriptionObjectId,
                shareSubscriptionStatus,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DataShare.DataShareData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="createdOn"> Time at which the share was created. </param>
        /// <param name="description"> Share description. </param>
        /// <param name="provisioningState"> Gets or sets the provisioning state. </param>
        /// <param name="shareKind"> Share kind. </param>
        /// <param name="terms"> Share terms. </param>
        /// <param name="userEmail"> Email of the user who created the resource. </param>
        /// <param name="userName"> Name of the user who created the resource. </param>
        /// <returns> A new <see cref="DataShare.DataShareData"/> instance for mocking. </returns>
        public static DataShareData DataShareData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DateTimeOffset? createdOn = null, string description = null, DataShareProvisioningState? provisioningState = null, DataShareKind? shareKind = null, string terms = null, string userEmail = null, string userName = null)
        {
            return new DataShareData(
                id,
                name,
                resourceType,
                systemData,
                createdOn,
                description,
                provisioningState,
                shareKind,
                terms,
                userEmail,
                userName,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ShareSubscriptionSynchronization"/>. </summary>
        /// <param name="durationInMilliSeconds"> Synchronization duration. </param>
        /// <param name="endOn"> End time of synchronization. </param>
        /// <param name="message"> message of Synchronization. </param>
        /// <param name="startOn"> start time of synchronization. </param>
        /// <param name="status"> Raw Status. </param>
        /// <param name="synchronizationId"> Synchronization id. </param>
        /// <param name="synchronizationMode"> Synchronization Mode. </param>
        /// <returns> A new <see cref="Models.ShareSubscriptionSynchronization"/> instance for mocking. </returns>
        public static ShareSubscriptionSynchronization ShareSubscriptionSynchronization(int? durationInMilliSeconds = null, DateTimeOffset? endOn = null, string message = null, DateTimeOffset? startOn = null, string status = null, Guid synchronizationId = default, SynchronizationMode? synchronizationMode = null)
        {
            return new ShareSubscriptionSynchronization(
                durationInMilliSeconds,
                endOn,
                message,
                startOn,
                status,
                synchronizationId,
                synchronizationMode,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConsumerSourceDataSet"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="dataSetId"> DataSet Id. </param>
        /// <param name="dataSetLocation"> Location of the data set. </param>
        /// <param name="dataSetName"> DataSet name. </param>
        /// <param name="dataSetPath"> DataSet path. </param>
        /// <param name="dataSetType"> Type of data set. </param>
        /// <returns> A new <see cref="Models.ConsumerSourceDataSet"/> instance for mocking. </returns>
        public static ConsumerSourceDataSet ConsumerSourceDataSet(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, Guid? dataSetId = null, AzureLocation? dataSetLocation = null, string dataSetName = null, string dataSetPath = null, ShareDataSetType? dataSetType = null)
        {
            return new ConsumerSourceDataSet(
                id,
                name,
                resourceType,
                systemData,
                dataSetId,
                dataSetLocation,
                dataSetName,
                dataSetPath,
                dataSetType,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DataShare.ShareSubscriptionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="createdOn"> Time at which the share subscription was created. </param>
        /// <param name="expireOn"> The expiration date of the share subscription. </param>
        /// <param name="invitationId"> The invitation id. </param>
        /// <param name="providerEmail"> Email of the provider who created the resource. </param>
        /// <param name="providerName"> Name of the provider who created the resource. </param>
        /// <param name="providerTenantName"> Tenant name of the provider who created the resource. </param>
        /// <param name="provisioningState"> Provisioning state of the share subscription. </param>
        /// <param name="shareDescription"> Description of share. </param>
        /// <param name="shareKind"> Kind of share. </param>
        /// <param name="shareName"> Name of the share. </param>
        /// <param name="shareSubscriptionStatus"> Gets the current status of share subscription. </param>
        /// <param name="shareTerms"> Terms of a share. </param>
        /// <param name="sourceShareLocation"> Source share location. </param>
        /// <param name="userEmail"> Email of the user who created the resource. </param>
        /// <param name="userName"> Name of the user who created the resource. </param>
        /// <returns> A new <see cref="DataShare.ShareSubscriptionData"/> instance for mocking. </returns>
        public static ShareSubscriptionData ShareSubscriptionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DateTimeOffset? createdOn = null, DateTimeOffset? expireOn = null, Guid invitationId = default, string providerEmail = null, string providerName = null, string providerTenantName = null, DataShareProvisioningState? provisioningState = null, string shareDescription = null, DataShareKind? shareKind = null, string shareName = null, ShareSubscriptionStatus? shareSubscriptionStatus = null, string shareTerms = null, AzureLocation sourceShareLocation = default, string userEmail = null, string userName = null)
        {
            return new ShareSubscriptionData(
                id,
                name,
                resourceType,
                systemData,
                createdOn,
                expireOn,
                invitationId,
                providerEmail,
                providerName,
                providerTenantName,
                provisioningState,
                shareDescription,
                shareKind,
                shareName,
                shareSubscriptionStatus,
                shareTerms,
                sourceShareLocation,
                userEmail,
                userName,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DataShare.DataShareSynchronizationSettingData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="kind"> Kind of synchronization setting. </param>
        /// <returns> A new <see cref="DataShare.DataShareSynchronizationSettingData"/> instance for mocking. </returns>
        public static DataShareSynchronizationSettingData DataShareSynchronizationSettingData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string kind = null)
        {
            return new DataShareSynchronizationSettingData(
                id,
                name,
                resourceType,
                systemData,
                kind == null ? default : new SynchronizationSettingKind(kind),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DataShare.DataShareTriggerData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="kind"> Kind of synchronization on trigger. </param>
        /// <returns> A new <see cref="DataShare.DataShareTriggerData"/> instance for mocking. </returns>
        public static DataShareTriggerData DataShareTriggerData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string kind = null)
        {
            return new DataShareTriggerData(
                id,
                name,
                resourceType,
                systemData,
                kind == null ? default : new TriggerKind(kind),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AdlsGen1FileDataSet"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="accountName"> The ADLS account name. </param>
        /// <param name="dataSetId"> Unique id for identifying a data set resource. </param>
        /// <param name="fileName"> The file name in the ADLS account. </param>
        /// <param name="folderPath"> The folder path within the ADLS account. </param>
        /// <param name="resourceGroup"> Resource group of ADLS account. </param>
        /// <param name="subscriptionId"> Subscription id of ADLS account. </param>
        /// <returns> A new <see cref="Models.AdlsGen1FileDataSet"/> instance for mocking. </returns>
        public static AdlsGen1FileDataSet AdlsGen1FileDataSet(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string accountName = null, Guid? dataSetId = null, string fileName = null, string folderPath = null, string resourceGroup = null, string subscriptionId = null)
        {
            return new AdlsGen1FileDataSet(
                id,
                name,
                resourceType,
                systemData,
                DataSetKind.AdlsGen1File,
                serializedAdditionalRawData: null,
                accountName,
                dataSetId,
                fileName,
                folderPath,
                resourceGroup,
                subscriptionId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AdlsGen1FolderDataSet"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="accountName"> The ADLS account name. </param>
        /// <param name="dataSetId"> Unique id for identifying a data set resource. </param>
        /// <param name="folderPath"> The folder path within the ADLS account. </param>
        /// <param name="resourceGroup"> Resource group of ADLS account. </param>
        /// <param name="subscriptionId"> Subscription id of ADLS account. </param>
        /// <returns> A new <see cref="Models.AdlsGen1FolderDataSet"/> instance for mocking. </returns>
        public static AdlsGen1FolderDataSet AdlsGen1FolderDataSet(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string accountName = null, Guid? dataSetId = null, string folderPath = null, string resourceGroup = null, string subscriptionId = null)
        {
            return new AdlsGen1FolderDataSet(
                id,
                name,
                resourceType,
                systemData,
                DataSetKind.AdlsGen1Folder,
                serializedAdditionalRawData: null,
                accountName,
                dataSetId,
                folderPath,
                resourceGroup,
                subscriptionId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AdlsGen2FileDataSet"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="dataSetId"> Unique id for identifying a data set resource. </param>
        /// <param name="filePath"> File path within the file system. </param>
        /// <param name="fileSystem"> File system to which the file belongs. </param>
        /// <param name="resourceGroup"> Resource group of storage account. </param>
        /// <param name="storageAccountName"> Storage account name of the source data set. </param>
        /// <param name="subscriptionId"> Subscription id of storage account. </param>
        /// <returns> A new <see cref="Models.AdlsGen2FileDataSet"/> instance for mocking. </returns>
        public static AdlsGen2FileDataSet AdlsGen2FileDataSet(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, Guid? dataSetId = null, string filePath = null, string fileSystem = null, string resourceGroup = null, string storageAccountName = null, string subscriptionId = null)
        {
            return new AdlsGen2FileDataSet(
                id,
                name,
                resourceType,
                systemData,
                DataSetKind.AdlsGen2File,
                serializedAdditionalRawData: null,
                dataSetId,
                filePath,
                fileSystem,
                resourceGroup,
                storageAccountName,
                subscriptionId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AdlsGen2FileDataSetMapping"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="dataSetId"> The id of the source data set. </param>
        /// <param name="dataSetMappingStatus"> Gets the status of the data set mapping. </param>
        /// <param name="filePath"> File path within the file system. </param>
        /// <param name="fileSystem"> File system to which the file belongs. </param>
        /// <param name="outputType"> Type of output file. </param>
        /// <param name="provisioningState"> Provisioning state of the data set mapping. </param>
        /// <param name="resourceGroup"> Resource group of storage account. </param>
        /// <param name="storageAccountName"> Storage account name of the source data set. </param>
        /// <param name="subscriptionId"> Subscription id of storage account. </param>
        /// <returns> A new <see cref="Models.AdlsGen2FileDataSetMapping"/> instance for mocking. </returns>
        public static AdlsGen2FileDataSetMapping AdlsGen2FileDataSetMapping(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, Guid dataSetId = default, DataSetMappingStatus? dataSetMappingStatus = null, string filePath = null, string fileSystem = null, DataShareOutputType? outputType = null, DataShareProvisioningState? provisioningState = null, string resourceGroup = null, string storageAccountName = null, string subscriptionId = null)
        {
            return new AdlsGen2FileDataSetMapping(
                id,
                name,
                resourceType,
                systemData,
                DataSetMappingKind.AdlsGen2File,
                serializedAdditionalRawData: null,
                dataSetId,
                dataSetMappingStatus,
                filePath,
                fileSystem,
                outputType,
                provisioningState,
                resourceGroup,
                storageAccountName,
                subscriptionId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AdlsGen2FileSystemDataSet"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="dataSetId"> Unique id for identifying a data set resource. </param>
        /// <param name="fileSystem"> The file system name. </param>
        /// <param name="resourceGroup"> Resource group of storage account. </param>
        /// <param name="storageAccountName"> Storage account name of the source data set. </param>
        /// <param name="subscriptionId"> Subscription id of storage account. </param>
        /// <returns> A new <see cref="Models.AdlsGen2FileSystemDataSet"/> instance for mocking. </returns>
        public static AdlsGen2FileSystemDataSet AdlsGen2FileSystemDataSet(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, Guid? dataSetId = null, string fileSystem = null, string resourceGroup = null, string storageAccountName = null, string subscriptionId = null)
        {
            return new AdlsGen2FileSystemDataSet(
                id,
                name,
                resourceType,
                systemData,
                DataSetKind.AdlsGen2FileSystem,
                serializedAdditionalRawData: null,
                dataSetId,
                fileSystem,
                resourceGroup,
                storageAccountName,
                subscriptionId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AdlsGen2FileSystemDataSetMapping"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="dataSetId"> The id of the source data set. </param>
        /// <param name="dataSetMappingStatus"> Gets the status of the data set mapping. </param>
        /// <param name="fileSystem"> The file system name. </param>
        /// <param name="provisioningState"> Provisioning state of the data set mapping. </param>
        /// <param name="resourceGroup"> Resource group of storage account. </param>
        /// <param name="storageAccountName"> Storage account name of the source data set. </param>
        /// <param name="subscriptionId"> Subscription id of storage account. </param>
        /// <returns> A new <see cref="Models.AdlsGen2FileSystemDataSetMapping"/> instance for mocking. </returns>
        public static AdlsGen2FileSystemDataSetMapping AdlsGen2FileSystemDataSetMapping(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, Guid dataSetId = default, DataSetMappingStatus? dataSetMappingStatus = null, string fileSystem = null, DataShareProvisioningState? provisioningState = null, string resourceGroup = null, string storageAccountName = null, string subscriptionId = null)
        {
            return new AdlsGen2FileSystemDataSetMapping(
                id,
                name,
                resourceType,
                systemData,
                DataSetMappingKind.AdlsGen2FileSystem,
                serializedAdditionalRawData: null,
                dataSetId,
                dataSetMappingStatus,
                fileSystem,
                provisioningState,
                resourceGroup,
                storageAccountName,
                subscriptionId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AdlsGen2FolderDataSet"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="dataSetId"> Unique id for identifying a data set resource. </param>
        /// <param name="fileSystem"> File system to which the folder belongs. </param>
        /// <param name="folderPath"> Folder path within the file system. </param>
        /// <param name="resourceGroup"> Resource group of storage account. </param>
        /// <param name="storageAccountName"> Storage account name of the source data set. </param>
        /// <param name="subscriptionId"> Subscription id of storage account. </param>
        /// <returns> A new <see cref="Models.AdlsGen2FolderDataSet"/> instance for mocking. </returns>
        public static AdlsGen2FolderDataSet AdlsGen2FolderDataSet(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, Guid? dataSetId = null, string fileSystem = null, string folderPath = null, string resourceGroup = null, string storageAccountName = null, string subscriptionId = null)
        {
            return new AdlsGen2FolderDataSet(
                id,
                name,
                resourceType,
                systemData,
                DataSetKind.AdlsGen2Folder,
                serializedAdditionalRawData: null,
                dataSetId,
                fileSystem,
                folderPath,
                resourceGroup,
                storageAccountName,
                subscriptionId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AdlsGen2FolderDataSetMapping"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="dataSetId"> The id of the source data set. </param>
        /// <param name="dataSetMappingStatus"> Gets the status of the data set mapping. </param>
        /// <param name="fileSystem"> File system to which the folder belongs. </param>
        /// <param name="folderPath"> Folder path within the file system. </param>
        /// <param name="provisioningState"> Provisioning state of the data set mapping. </param>
        /// <param name="resourceGroup"> Resource group of storage account. </param>
        /// <param name="storageAccountName"> Storage account name of the source data set. </param>
        /// <param name="subscriptionId"> Subscription id of storage account. </param>
        /// <returns> A new <see cref="Models.AdlsGen2FolderDataSetMapping"/> instance for mocking. </returns>
        public static AdlsGen2FolderDataSetMapping AdlsGen2FolderDataSetMapping(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, Guid dataSetId = default, DataSetMappingStatus? dataSetMappingStatus = null, string fileSystem = null, string folderPath = null, DataShareProvisioningState? provisioningState = null, string resourceGroup = null, string storageAccountName = null, string subscriptionId = null)
        {
            return new AdlsGen2FolderDataSetMapping(
                id,
                name,
                resourceType,
                systemData,
                DataSetMappingKind.AdlsGen2Folder,
                serializedAdditionalRawData: null,
                dataSetId,
                dataSetMappingStatus,
                fileSystem,
                folderPath,
                provisioningState,
                resourceGroup,
                storageAccountName,
                subscriptionId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.BlobContainerDataSet"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="containerName"> BLOB Container name. </param>
        /// <param name="dataSetId"> Unique id for identifying a data set resource. </param>
        /// <param name="resourceGroup"> Resource group of storage account. </param>
        /// <param name="storageAccountName"> Storage account name of the source data set. </param>
        /// <param name="subscriptionId"> Subscription id of storage account. </param>
        /// <returns> A new <see cref="Models.BlobContainerDataSet"/> instance for mocking. </returns>
        public static BlobContainerDataSet BlobContainerDataSet(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string containerName = null, Guid? dataSetId = null, string resourceGroup = null, string storageAccountName = null, string subscriptionId = null)
        {
            return new BlobContainerDataSet(
                id,
                name,
                resourceType,
                systemData,
                DataSetKind.Container,
                serializedAdditionalRawData: null,
                containerName,
                dataSetId,
                resourceGroup,
                storageAccountName,
                subscriptionId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.BlobContainerDataSetMapping"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="containerName"> BLOB Container name. </param>
        /// <param name="dataSetId"> The id of the source data set. </param>
        /// <param name="dataSetMappingStatus"> Gets the status of the data set mapping. </param>
        /// <param name="provisioningState"> Provisioning state of the data set mapping. </param>
        /// <param name="resourceGroup"> Resource group of storage account. </param>
        /// <param name="storageAccountName"> Storage account name of the source data set. </param>
        /// <param name="subscriptionId"> Subscription id of storage account. </param>
        /// <returns> A new <see cref="Models.BlobContainerDataSetMapping"/> instance for mocking. </returns>
        public static BlobContainerDataSetMapping BlobContainerDataSetMapping(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string containerName = null, Guid dataSetId = default, DataSetMappingStatus? dataSetMappingStatus = null, DataShareProvisioningState? provisioningState = null, string resourceGroup = null, string storageAccountName = null, string subscriptionId = null)
        {
            return new BlobContainerDataSetMapping(
                id,
                name,
                resourceType,
                systemData,
                DataSetMappingKind.Container,
                serializedAdditionalRawData: null,
                containerName,
                dataSetId,
                dataSetMappingStatus,
                provisioningState,
                resourceGroup,
                storageAccountName,
                subscriptionId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.BlobDataSet"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="containerName"> Container that has the file path. </param>
        /// <param name="dataSetId"> Unique id for identifying a data set resource. </param>
        /// <param name="filePath"> File path within the source data set. </param>
        /// <param name="resourceGroup"> Resource group of storage account. </param>
        /// <param name="storageAccountName"> Storage account name of the source data set. </param>
        /// <param name="subscriptionId"> Subscription id of storage account. </param>
        /// <returns> A new <see cref="Models.BlobDataSet"/> instance for mocking. </returns>
        public static BlobDataSet BlobDataSet(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string containerName = null, Guid? dataSetId = null, string filePath = null, string resourceGroup = null, string storageAccountName = null, string subscriptionId = null)
        {
            return new BlobDataSet(
                id,
                name,
                resourceType,
                systemData,
                DataSetKind.Blob,
                serializedAdditionalRawData: null,
                containerName,
                dataSetId,
                filePath,
                resourceGroup,
                storageAccountName,
                subscriptionId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.BlobDataSetMapping"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="containerName"> Container that has the file path. </param>
        /// <param name="dataSetId"> The id of the source data set. </param>
        /// <param name="dataSetMappingStatus"> Gets the status of the data set mapping. </param>
        /// <param name="filePath"> File path within the source data set. </param>
        /// <param name="outputType"> File output type. </param>
        /// <param name="provisioningState"> Provisioning state of the data set mapping. </param>
        /// <param name="resourceGroup"> Resource group of storage account. </param>
        /// <param name="storageAccountName"> Storage account name of the source data set. </param>
        /// <param name="subscriptionId"> Subscription id of storage account. </param>
        /// <returns> A new <see cref="Models.BlobDataSetMapping"/> instance for mocking. </returns>
        public static BlobDataSetMapping BlobDataSetMapping(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string containerName = null, Guid dataSetId = default, DataSetMappingStatus? dataSetMappingStatus = null, string filePath = null, DataShareOutputType? outputType = null, DataShareProvisioningState? provisioningState = null, string resourceGroup = null, string storageAccountName = null, string subscriptionId = null)
        {
            return new BlobDataSetMapping(
                id,
                name,
                resourceType,
                systemData,
                DataSetMappingKind.Blob,
                serializedAdditionalRawData: null,
                containerName,
                dataSetId,
                dataSetMappingStatus,
                filePath,
                outputType,
                provisioningState,
                resourceGroup,
                storageAccountName,
                subscriptionId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.BlobFolderDataSet"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="containerName"> Container that has the file path. </param>
        /// <param name="dataSetId"> Unique id for identifying a data set resource. </param>
        /// <param name="prefix"> Prefix for blob folder. </param>
        /// <param name="resourceGroup"> Resource group of storage account. </param>
        /// <param name="storageAccountName"> Storage account name of the source data set. </param>
        /// <param name="subscriptionId"> Subscription id of storage account. </param>
        /// <returns> A new <see cref="Models.BlobFolderDataSet"/> instance for mocking. </returns>
        public static BlobFolderDataSet BlobFolderDataSet(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string containerName = null, Guid? dataSetId = null, string prefix = null, string resourceGroup = null, string storageAccountName = null, string subscriptionId = null)
        {
            return new BlobFolderDataSet(
                id,
                name,
                resourceType,
                systemData,
                DataSetKind.BlobFolder,
                serializedAdditionalRawData: null,
                containerName,
                dataSetId,
                prefix,
                resourceGroup,
                storageAccountName,
                subscriptionId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.BlobFolderDataSetMapping"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="containerName"> Container that has the file path. </param>
        /// <param name="dataSetId"> The id of the source data set. </param>
        /// <param name="dataSetMappingStatus"> Gets the status of the data set mapping. </param>
        /// <param name="prefix"> Prefix for blob folder. </param>
        /// <param name="provisioningState"> Provisioning state of the data set mapping. </param>
        /// <param name="resourceGroup"> Resource group of storage account. </param>
        /// <param name="storageAccountName"> Storage account name of the source data set. </param>
        /// <param name="subscriptionId"> Subscription id of storage account. </param>
        /// <returns> A new <see cref="Models.BlobFolderDataSetMapping"/> instance for mocking. </returns>
        public static BlobFolderDataSetMapping BlobFolderDataSetMapping(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string containerName = null, Guid dataSetId = default, DataSetMappingStatus? dataSetMappingStatus = null, string prefix = null, DataShareProvisioningState? provisioningState = null, string resourceGroup = null, string storageAccountName = null, string subscriptionId = null)
        {
            return new BlobFolderDataSetMapping(
                id,
                name,
                resourceType,
                systemData,
                DataSetMappingKind.BlobFolder,
                serializedAdditionalRawData: null,
                containerName,
                dataSetId,
                dataSetMappingStatus,
                prefix,
                provisioningState,
                resourceGroup,
                storageAccountName,
                subscriptionId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KustoClusterDataSet"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="dataSetId"> Unique id for identifying a data set resource. </param>
        /// <param name="kustoClusterResourceId"> Resource id of the kusto cluster. </param>
        /// <param name="location"> Location of the kusto cluster. </param>
        /// <param name="provisioningState"> Provisioning state of the kusto cluster data set. </param>
        /// <returns> A new <see cref="Models.KustoClusterDataSet"/> instance for mocking. </returns>
        public static KustoClusterDataSet KustoClusterDataSet(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, Guid? dataSetId = null, ResourceIdentifier kustoClusterResourceId = null, AzureLocation? location = null, DataShareProvisioningState? provisioningState = null)
        {
            return new KustoClusterDataSet(
                id,
                name,
                resourceType,
                systemData,
                DataSetKind.KustoCluster,
                serializedAdditionalRawData: null,
                dataSetId,
                kustoClusterResourceId,
                location,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KustoClusterDataSetMapping"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="dataSetId"> The id of the source data set. </param>
        /// <param name="dataSetMappingStatus"> Gets the status of the data set mapping. </param>
        /// <param name="kustoClusterResourceId"> Resource id of the sink kusto cluster. </param>
        /// <param name="location"> Location of the sink kusto cluster. </param>
        /// <param name="provisioningState"> Provisioning state of the data set mapping. </param>
        /// <returns> A new <see cref="Models.KustoClusterDataSetMapping"/> instance for mocking. </returns>
        public static KustoClusterDataSetMapping KustoClusterDataSetMapping(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, Guid dataSetId = default, DataSetMappingStatus? dataSetMappingStatus = null, ResourceIdentifier kustoClusterResourceId = null, AzureLocation? location = null, DataShareProvisioningState? provisioningState = null)
        {
            return new KustoClusterDataSetMapping(
                id,
                name,
                resourceType,
                systemData,
                DataSetMappingKind.KustoCluster,
                serializedAdditionalRawData: null,
                dataSetId,
                dataSetMappingStatus,
                kustoClusterResourceId,
                location,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KustoDatabaseDataSet"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="dataSetId"> Unique id for identifying a data set resource. </param>
        /// <param name="kustoDatabaseResourceId"> Resource id of the kusto database. </param>
        /// <param name="location"> Location of the kusto cluster. </param>
        /// <param name="provisioningState"> Provisioning state of the kusto database data set. </param>
        /// <returns> A new <see cref="Models.KustoDatabaseDataSet"/> instance for mocking. </returns>
        public static KustoDatabaseDataSet KustoDatabaseDataSet(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, Guid? dataSetId = null, ResourceIdentifier kustoDatabaseResourceId = null, AzureLocation? location = null, DataShareProvisioningState? provisioningState = null)
        {
            return new KustoDatabaseDataSet(
                id,
                name,
                resourceType,
                systemData,
                DataSetKind.KustoDatabase,
                serializedAdditionalRawData: null,
                dataSetId,
                kustoDatabaseResourceId,
                location,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KustoDatabaseDataSetMapping"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="dataSetId"> The id of the source data set. </param>
        /// <param name="dataSetMappingStatus"> Gets the status of the data set mapping. </param>
        /// <param name="kustoClusterResourceId"> Resource id of the sink kusto cluster. </param>
        /// <param name="location"> Location of the sink kusto cluster. </param>
        /// <param name="provisioningState"> Provisioning state of the data set mapping. </param>
        /// <returns> A new <see cref="Models.KustoDatabaseDataSetMapping"/> instance for mocking. </returns>
        public static KustoDatabaseDataSetMapping KustoDatabaseDataSetMapping(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, Guid dataSetId = default, DataSetMappingStatus? dataSetMappingStatus = null, ResourceIdentifier kustoClusterResourceId = null, AzureLocation? location = null, DataShareProvisioningState? provisioningState = null)
        {
            return new KustoDatabaseDataSetMapping(
                id,
                name,
                resourceType,
                systemData,
                DataSetMappingKind.KustoDatabase,
                serializedAdditionalRawData: null,
                dataSetId,
                dataSetMappingStatus,
                kustoClusterResourceId,
                location,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KustoTableDataSet"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="dataSetId"> Unique id for identifying a data set resource. </param>
        /// <param name="kustoDatabaseResourceId"> Resource id of the kusto database. </param>
        /// <param name="location"> Location of the kusto cluster. </param>
        /// <param name="provisioningState"> Provisioning state of the kusto table data set. </param>
        /// <param name="tableLevelSharingProperties"> Table level sharing properties for kusto database. </param>
        /// <returns> A new <see cref="Models.KustoTableDataSet"/> instance for mocking. </returns>
        public static KustoTableDataSet KustoTableDataSet(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, Guid? dataSetId = null, ResourceIdentifier kustoDatabaseResourceId = null, AzureLocation? location = null, DataShareProvisioningState? provisioningState = null, TableLevelSharingProperties tableLevelSharingProperties = null)
        {
            return new KustoTableDataSet(
                id,
                name,
                resourceType,
                systemData,
                DataSetKind.KustoTable,
                serializedAdditionalRawData: null,
                dataSetId,
                kustoDatabaseResourceId,
                location,
                provisioningState,
                tableLevelSharingProperties);
        }

        /// <summary> Initializes a new instance of <see cref="Models.KustoTableDataSetMapping"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="dataSetId"> The id of the source data set. </param>
        /// <param name="dataSetMappingStatus"> Gets the status of the data set mapping. </param>
        /// <param name="kustoClusterResourceId"> Resource id of the sink kusto cluster. </param>
        /// <param name="location"> Location of the sink kusto cluster. </param>
        /// <param name="provisioningState"> Provisioning state of the data set mapping. </param>
        /// <returns> A new <see cref="Models.KustoTableDataSetMapping"/> instance for mocking. </returns>
        public static KustoTableDataSetMapping KustoTableDataSetMapping(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, Guid dataSetId = default, DataSetMappingStatus? dataSetMappingStatus = null, ResourceIdentifier kustoClusterResourceId = null, AzureLocation? location = null, DataShareProvisioningState? provisioningState = null)
        {
            return new KustoTableDataSetMapping(
                id,
                name,
                resourceType,
                systemData,
                DataSetMappingKind.KustoTable,
                serializedAdditionalRawData: null,
                dataSetId,
                dataSetMappingStatus,
                kustoClusterResourceId,
                location,
                provisioningState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ScheduledSourceSynchronizationSetting"/>. </summary>
        /// <param name="recurrenceInterval"> Recurrence Interval. </param>
        /// <param name="synchronizeOn"> Synchronization time. </param>
        /// <returns> A new <see cref="Models.ScheduledSourceSynchronizationSetting"/> instance for mocking. </returns>
        public static ScheduledSourceSynchronizationSetting ScheduledSourceSynchronizationSetting(DataShareSynchronizationRecurrenceInterval? recurrenceInterval = null, DateTimeOffset? synchronizeOn = null)
        {
            return new ScheduledSourceSynchronizationSetting(SourceShareSynchronizationSettingKind.ScheduleBased, serializedAdditionalRawData: null, recurrenceInterval, synchronizeOn);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ScheduledSynchronizationSetting"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="createdOn"> Time at which the synchronization setting was created. </param>
        /// <param name="provisioningState"> Gets or sets the provisioning state. </param>
        /// <param name="recurrenceInterval"> Recurrence Interval. </param>
        /// <param name="synchronizeOn"> Synchronization time. </param>
        /// <param name="userName"> Name of the user who created the synchronization setting. </param>
        /// <returns> A new <see cref="Models.ScheduledSynchronizationSetting"/> instance for mocking. </returns>
        public static ScheduledSynchronizationSetting ScheduledSynchronizationSetting(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DateTimeOffset? createdOn = null, DataShareProvisioningState? provisioningState = null, DataShareSynchronizationRecurrenceInterval recurrenceInterval = default, DateTimeOffset synchronizeOn = default, string userName = null)
        {
            return new ScheduledSynchronizationSetting(
                id,
                name,
                resourceType,
                systemData,
                SynchronizationSettingKind.ScheduleBased,
                serializedAdditionalRawData: null,
                createdOn,
                provisioningState,
                recurrenceInterval,
                synchronizeOn,
                userName);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ScheduledTrigger"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="createdOn"> Time at which the trigger was created. </param>
        /// <param name="provisioningState"> Gets the provisioning state. </param>
        /// <param name="recurrenceInterval"> Recurrence Interval. </param>
        /// <param name="synchronizationMode"> Synchronization mode. </param>
        /// <param name="synchronizeOn"> Synchronization time. </param>
        /// <param name="triggerStatus"> Gets the trigger state. </param>
        /// <param name="userName"> Name of the user who created the trigger. </param>
        /// <returns> A new <see cref="Models.ScheduledTrigger"/> instance for mocking. </returns>
        public static ScheduledTrigger ScheduledTrigger(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DateTimeOffset? createdOn = null, DataShareProvisioningState? provisioningState = null, DataShareSynchronizationRecurrenceInterval recurrenceInterval = default, SynchronizationMode? synchronizationMode = null, DateTimeOffset synchronizeOn = default, DataShareTriggerStatus? triggerStatus = null, string userName = null)
        {
            return new ScheduledTrigger(
                id,
                name,
                resourceType,
                systemData,
                TriggerKind.ScheduleBased,
                serializedAdditionalRawData: null,
                createdOn,
                provisioningState,
                recurrenceInterval,
                synchronizationMode,
                synchronizeOn,
                triggerStatus,
                userName);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SqlDBTableDataSet"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="databaseName"> Database name of the source data set. </param>
        /// <param name="dataSetId"> Unique id for identifying a data set resource. </param>
        /// <param name="schemaName"> Schema of the table. Default value is dbo. </param>
        /// <param name="sqlServerResourceId"> Resource id of SQL server. </param>
        /// <param name="tableName"> SQL DB table name. </param>
        /// <returns> A new <see cref="Models.SqlDBTableDataSet"/> instance for mocking. </returns>
        public static SqlDBTableDataSet SqlDBTableDataSet(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string databaseName = null, Guid? dataSetId = null, string schemaName = null, ResourceIdentifier sqlServerResourceId = null, string tableName = null)
        {
            return new SqlDBTableDataSet(
                id,
                name,
                resourceType,
                systemData,
                DataSetKind.SqlDBTable,
                serializedAdditionalRawData: null,
                databaseName,
                dataSetId,
                schemaName,
                sqlServerResourceId,
                tableName);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SqlDBTableDataSetMapping"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="databaseName"> DatabaseName name of the sink data set. </param>
        /// <param name="dataSetId"> The id of the source data set. </param>
        /// <param name="dataSetMappingStatus"> Gets the status of the data set mapping. </param>
        /// <param name="provisioningState"> Provisioning state of the data set mapping. </param>
        /// <param name="schemaName"> Schema of the table. Default value is dbo. </param>
        /// <param name="sqlServerResourceId"> Resource id of SQL server. </param>
        /// <param name="tableName"> SQL DB table name. </param>
        /// <returns> A new <see cref="Models.SqlDBTableDataSetMapping"/> instance for mocking. </returns>
        public static SqlDBTableDataSetMapping SqlDBTableDataSetMapping(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string databaseName = null, Guid dataSetId = default, DataSetMappingStatus? dataSetMappingStatus = null, DataShareProvisioningState? provisioningState = null, string schemaName = null, ResourceIdentifier sqlServerResourceId = null, string tableName = null)
        {
            return new SqlDBTableDataSetMapping(
                id,
                name,
                resourceType,
                systemData,
                DataSetMappingKind.SqlDBTable,
                serializedAdditionalRawData: null,
                databaseName,
                dataSetId,
                dataSetMappingStatus,
                provisioningState,
                schemaName,
                sqlServerResourceId,
                tableName);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SqlDWTableDataSet"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="dataSetId"> Unique id for identifying a data set resource. </param>
        /// <param name="dataWarehouseName"> DataWarehouse name of the source data set. </param>
        /// <param name="schemaName"> Schema of the table. Default value is dbo. </param>
        /// <param name="sqlServerResourceId"> Resource id of SQL server. </param>
        /// <param name="tableName"> SQL DW table name. </param>
        /// <returns> A new <see cref="Models.SqlDWTableDataSet"/> instance for mocking. </returns>
        public static SqlDWTableDataSet SqlDWTableDataSet(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, Guid? dataSetId = null, string dataWarehouseName = null, string schemaName = null, ResourceIdentifier sqlServerResourceId = null, string tableName = null)
        {
            return new SqlDWTableDataSet(
                id,
                name,
                resourceType,
                systemData,
                DataSetKind.SqlDWTable,
                serializedAdditionalRawData: null,
                dataSetId,
                dataWarehouseName,
                schemaName,
                sqlServerResourceId,
                tableName);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SqlDWTableDataSetMapping"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="dataSetId"> The id of the source data set. </param>
        /// <param name="dataSetMappingStatus"> Gets the status of the data set mapping. </param>
        /// <param name="dataWarehouseName"> DataWarehouse name of the source data set. </param>
        /// <param name="provisioningState"> Provisioning state of the data set mapping. </param>
        /// <param name="schemaName"> Schema of the table. Default value is dbo. </param>
        /// <param name="sqlServerResourceId"> Resource id of SQL server. </param>
        /// <param name="tableName"> SQL DW table name. </param>
        /// <returns> A new <see cref="Models.SqlDWTableDataSetMapping"/> instance for mocking. </returns>
        public static SqlDWTableDataSetMapping SqlDWTableDataSetMapping(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, Guid dataSetId = default, DataSetMappingStatus? dataSetMappingStatus = null, string dataWarehouseName = null, DataShareProvisioningState? provisioningState = null, string schemaName = null, ResourceIdentifier sqlServerResourceId = null, string tableName = null)
        {
            return new SqlDWTableDataSetMapping(
                id,
                name,
                resourceType,
                systemData,
                DataSetMappingKind.SqlDWTable,
                serializedAdditionalRawData: null,
                dataSetId,
                dataSetMappingStatus,
                dataWarehouseName,
                provisioningState,
                schemaName,
                sqlServerResourceId,
                tableName);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseWorkspaceSqlPoolTableDataSet"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="dataSetId"> Unique id for identifying a data set resource. </param>
        /// <param name="synapseWorkspaceSqlPoolTableResourceId"> Resource id of the Synapse Workspace SQL Pool Table. </param>
        /// <returns> A new <see cref="Models.SynapseWorkspaceSqlPoolTableDataSet"/> instance for mocking. </returns>
        public static SynapseWorkspaceSqlPoolTableDataSet SynapseWorkspaceSqlPoolTableDataSet(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, Guid? dataSetId = null, ResourceIdentifier synapseWorkspaceSqlPoolTableResourceId = null)
        {
            return new SynapseWorkspaceSqlPoolTableDataSet(
                id,
                name,
                resourceType,
                systemData,
                DataSetKind.SynapseWorkspaceSqlPoolTable,
                serializedAdditionalRawData: null,
                dataSetId,
                synapseWorkspaceSqlPoolTableResourceId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SynapseWorkspaceSqlPoolTableDataSetMapping"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="dataSetId"> The id of the source data set. </param>
        /// <param name="dataSetMappingStatus"> Gets the status of the data set mapping. </param>
        /// <param name="provisioningState"> Provisioning state of the data set mapping. </param>
        /// <param name="synapseWorkspaceSqlPoolTableResourceId"> Resource id of the Synapse Workspace SQL Pool Table. </param>
        /// <returns> A new <see cref="Models.SynapseWorkspaceSqlPoolTableDataSetMapping"/> instance for mocking. </returns>
        public static SynapseWorkspaceSqlPoolTableDataSetMapping SynapseWorkspaceSqlPoolTableDataSetMapping(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, Guid dataSetId = default, DataSetMappingStatus? dataSetMappingStatus = null, DataShareProvisioningState? provisioningState = null, ResourceIdentifier synapseWorkspaceSqlPoolTableResourceId = null)
        {
            return new SynapseWorkspaceSqlPoolTableDataSetMapping(
                id,
                name,
                resourceType,
                systemData,
                DataSetMappingKind.SynapseWorkspaceSqlPoolTable,
                serializedAdditionalRawData: null,
                dataSetId,
                dataSetMappingStatus,
                provisioningState,
                synapseWorkspaceSqlPoolTableResourceId);
        }
    }
}
