// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.DataShare.Models;

namespace Azure.ResourceManager.DataShare.Samples
{
    public partial class Sample_TenantResourceExtensions
    {
        // EmailRegistrations_ActivateEmail
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task ActivateEmail_EmailRegistrationsActivateEmail()
        {
            // Generated from example definition: specification/datashare/resource-manager/Microsoft.DataShare/stable/2021-08-01/examples/EmailRegistrations_ActivateEmail.json
            // this example is just showing the usage of "EmailRegistrations_ActivateEmail" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TenantResource created on azure
            // for more information of creating TenantResource, please refer to the document of TenantResource
            var tenantResource = client.GetTenants().GetAllAsync().GetAsyncEnumerator().Current;

            // invoke the operation
            AzureLocation location = new AzureLocation("East US 2");
            DataShareEmailRegistration emailRegistration = new DataShareEmailRegistration()
            {
                ActivationCode = "djsfhakj2lekowd3wepfklpwe9lpflcd",
            };
            DataShareEmailRegistration result = await tenantResource.ActivateEmailAsync(location, emailRegistration);

            Console.WriteLine($"Succeeded: {result}");
        }

        // EmailRegistrations_RegisterEmail
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task RegisterEmail_EmailRegistrationsRegisterEmail()
        {
            // Generated from example definition: specification/datashare/resource-manager/Microsoft.DataShare/stable/2021-08-01/examples/EmailRegistrations_RegisterEmail.json
            // this example is just showing the usage of "EmailRegistrations_RegisterEmail" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TenantResource created on azure
            // for more information of creating TenantResource, please refer to the document of TenantResource
            var tenantResource = client.GetTenants().GetAllAsync().GetAsyncEnumerator().Current;

            // invoke the operation
            AzureLocation location = new AzureLocation("East US 2");
            DataShareEmailRegistration result = await tenantResource.RegisterEmailAsync(location);

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
