// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> Warning object used by layers that have access to localized content, and propagate that to user. </summary>
    public partial class UserFacingWarningDetail
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="UserFacingWarningDetail"/>. </summary>
        /// <param name="warning"> Error details for the warning. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="warning"/> is null. </exception>
        internal UserFacingWarningDetail(ResponseError warning)
        {
            Argument.AssertNotNull(warning, nameof(warning));

            Warning = warning;
        }

        /// <summary> Initializes a new instance of <see cref="UserFacingWarningDetail"/>. </summary>
        /// <param name="resourceName"> Name of resource for which warning is raised. </param>
        /// <param name="warning"> Error details for the warning. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal UserFacingWarningDetail(string resourceName, ResponseError warning, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ResourceName = resourceName;
            Warning = warning;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="UserFacingWarningDetail"/> for deserialization. </summary>
        internal UserFacingWarningDetail()
        {
        }

        /// <summary> Name of resource for which warning is raised. </summary>
        public string ResourceName { get; }
        /// <summary> Error details for the warning. </summary>
        public ResponseError Warning { get; }
    }
}
